/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.category.Undefined;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class CategoriesManagerCache {
    private Set<Category> categories = new HashSet<Category>();
    private Undefined undefinedCategory;

    @Inject
    public CategoriesManagerCache(Undefined undefinedCategory) {
        this.undefinedCategory = undefinedCategory;
    }

    public Set<Category> getCategories() {
        return new HashSet<Category>(this.categories);
    }

    public void add(Category category) {
        this.categories.add(category);
    }

    public void addAll(Collection<Category> category) {
        this.categories.addAll(category);
    }

    public void addAllFromResourceTypes(List<ClientResourceType> clientResourceType) {
        this.addAll(this.getCategories(clientResourceType));
    }

    private List<Category> getCategories(List<ClientResourceType> resourceTypes) {
        return resourceTypes.stream().filter(clientResourceType -> clientResourceType.getCategory() != null).map(ResourceTypeDefinition::getCategory).collect(Collectors.toList());
    }

    public Category getCategory(String filterType) {
        if (filterType == null) {
            return this.undefinedCategory;
        }
        return this.getCategories().stream().filter(category -> category.getName().equals(filterType.toUpperCase())).findFirst().orElse((Category)this.undefinedCategory);
    }
}

