/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import java.util.HashMap;
import java.util.Map;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.ContextActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractDockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.ContextDefinition;
import org.uberfire.workbench.model.ContextDisplayMode;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

public abstract class AbstractMultiPartWorkbenchPanelPresenter<P extends AbstractMultiPartWorkbenchPanelPresenter<P>>
extends AbstractDockingWorkbenchPanelPresenter<P> {
    private final Map<PartDefinition, ContextActivity> contextActivities = new HashMap<PartDefinition, ContextActivity>();
    protected ActivityManager activityManager;
    private ContextActivity perspectiveContext = null;
    private ContextActivity panelContext = null;

    protected AbstractMultiPartWorkbenchPanelPresenter(WorkbenchPanelView<P> view, ActivityManager activityManager, PerspectiveManager perspectiveManager) {
        super(view, perspectiveManager);
        this.activityManager = activityManager;
    }

    private void buildPerspectiveContext() {
        ContextActivity activity;
        ContextDefinition contextDefinition = this.perspectiveManager.getLivePerspectiveDefinition().getContextDefinition();
        ContextDisplayMode contextDisplayMode = this.perspectiveManager.getLivePerspectiveDefinition().getContextDisplayMode();
        if (contextDefinition != null && contextDisplayMode == ContextDisplayMode.SHOW && (activity = this.activityManager.getActivity(ContextActivity.class, contextDefinition.getPlace())) != null) {
            this.perspectiveContext = activity;
        }
    }

    @Override
    public void setDefinition(PanelDefinition definition) {
        ContextActivity activity;
        super.setDefinition(definition);
        ContextDisplayMode perspectiveContextDisplayMode = this.perspectiveManager.getLivePerspectiveDefinition().getContextDisplayMode();
        if (definition.getContextDefinition() != null && perspectiveContextDisplayMode == ContextDisplayMode.SHOW && definition.getContextDisplayMode() == ContextDisplayMode.SHOW && (activity = this.activityManager.getActivity(ContextActivity.class, definition.getContextDefinition().getPlace())) != null) {
            this.panelContext = activity;
        }
        this.buildPerspectiveContext();
    }

    @Override
    public void addPart(WorkbenchPartPresenter part, String contextId) {
        super.addPart(part, contextId);
        ContextDisplayMode perspectiveContextDisplayMode = this.perspectiveManager.getLivePerspectiveDefinition().getContextDisplayMode();
        if (perspectiveContextDisplayMode == ContextDisplayMode.SHOW && this.getDefinition().getContextDisplayMode() == ContextDisplayMode.SHOW && part.getDefinition().getContextDisplayMode() == ContextDisplayMode.SHOW) {
            ContextActivity contextActivity = null;
            if (contextId != null) {
                contextActivity = this.activityManager.getActivity(ContextActivity.class, (PlaceRequest)new DefaultPlaceRequest(contextId));
            } else if (part.getDefinition().getContextDefinition() != null) {
                contextActivity = this.activityManager.getActivity(ContextActivity.class, part.getDefinition().getContextDefinition().getPlace());
            } else if (part.getContextId() != null) {
                contextActivity = this.activityManager.getActivity(ContextActivity.class, (PlaceRequest)new DefaultPlaceRequest(part.getContextId()));
            }
            if (contextActivity != null) {
                this.contextActivities.put(part.getDefinition(), contextActivity);
            }
        }
    }

    @Override
    public boolean removePart(PartDefinition part) {
        boolean removed = super.removePart(part);
        this.contextActivities.remove(part);
        return removed;
    }

    public ContextActivity resolveContext(PartDefinition part) {
        ContextActivity result = this.perspectiveContext;
        if (this.panelContext != null) {
            result = this.panelContext;
        }
        if (this.contextActivities.containsKey(part)) {
            result = this.contextActivities.get(part);
        }
        return result;
    }
}

