/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.ImmutableWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.panel.StaticFocusedResizePanel;
import org.uberfire.workbench.model.PartDefinition;

@Dependent
@Named(value="ImmutableWorkbenchPanelView")
public class ImmutableWorkbenchPanelView
extends AbstractWorkbenchPanelView<ImmutableWorkbenchPanelPresenter> {
    @Inject
    PlaceManager placeManager;
    @Inject
    StaticFocusedResizePanel panel;

    @PostConstruct
    void postConstruct() {
        Layouts.setToFillParent((Widget)this.panel);
        this.initWidget((Widget)this.panel);
    }

    public Widget getWidget() {
        return this.panel;
    }

    public StaticFocusedResizePanel getPanel() {
        return this.panel;
    }

    public void init(ImmutableWorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public ImmutableWorkbenchPanelPresenter getPresenter() {
        return (ImmutableWorkbenchPanelPresenter)this.presenter;
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        if (this.panel.getPartView() != null) {
            throw new RuntimeException("Uberfire Panel Invalid State: This panel support only one part.");
        }
        this.panel.setPart(view);
        this.onResize();
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        PartDefinition currentPartDefinition = this.getCurrentPartDefinition();
        return currentPartDefinition != null && currentPartDefinition.equals(part);
    }

    @Override
    public boolean removePart(PartDefinition part) {
        return false;
    }

    @Override
    public void setFocus(boolean hasFocus) {
        this.panel.setFocus(hasFocus);
    }

    public void onResize() {
        ((ImmutableWorkbenchPanelPresenter)this.presenter).onResize(this.getOffsetWidth(), this.getOffsetHeight());
        super.onResize();
    }

    PartDefinition getCurrentPartDefinition() {
        WorkbenchPartPresenter.View partView = this.panel.getPartView();
        if (partView == null) {
            return null;
        }
        WorkbenchPartPresenter presenter = partView.getPresenter();
        if (presenter == null) {
            return null;
        }
        return presenter.getDefinition();
    }

    @Override
    public Collection<PartDefinition> getParts() {
        PartDefinition currentPartDefinition = this.getCurrentPartDefinition();
        if (currentPartDefinition == null) {
            return new ArrayList<PartDefinition>();
        }
        return Arrays.asList(currentPartDefinition);
    }
}

