/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.docks;

import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.workbench.events.UberFireEvent;

public class UberfireDocksInteractionEvent
implements UberFireEvent {
    private final UberfireDock targetDock;
    private final UberfireDockPosition targetDockPosition;
    private final InteractionType type;

    public UberfireDocksInteractionEvent(UberfireDock targetDock, InteractionType type) {
        this.targetDock = targetDock;
        this.targetDockPosition = targetDock.getDockPosition();
        this.type = type;
    }

    public UberfireDocksInteractionEvent(UberfireDockPosition position, InteractionType type) {
        this.targetDock = null;
        this.targetDockPosition = position;
        this.type = type;
    }

    public UberfireDock getTargetDock() {
        return this.targetDock;
    }

    public UberfireDockPosition getTargetDockPosition() {
        return this.targetDockPosition;
    }

    public InteractionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UberfireDocksInteractionEvent that = (UberfireDocksInteractionEvent)o;
        if (this.targetDock != null ? !this.targetDock.equals(that.targetDock) : that.targetDock != null) {
            return false;
        }
        if (this.targetDockPosition != that.targetDockPosition) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.targetDock != null ? this.targetDock.hashCode() : 0;
        result = 31 * result + (this.targetDockPosition != null ? this.targetDockPosition.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = ~(~result);
        return result;
    }

    public static enum InteractionType {
        OPENED,
        CLOSED,
        RESIZED;

    }
}

