/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractActivityTest {
    public abstract Activity getActivityUnderTest();

    public abstract PlaceManager getPlaceManager();

    @Test(expected=IllegalStateException.class)
    public void onOpenShouldFailWhenActivityNotStarted() {
        this.getActivityUnderTest().onOpen();
    }

    @Test
    public void onOpenShouldSucceedWhenActivityStarted() throws Exception {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        ((PlaceManager)Mockito.verify((Object)this.getPlaceManager())).executeOnOpenCallbacks(a.getPlace());
    }

    @Test(expected=IllegalStateException.class)
    public void onOpenShouldFailWhenActivityAlreadyOpen() {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        a.onOpen();
    }

    @Test
    public void onShutdownShouldSucceedWhenActivityNeverOpened() throws Exception {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onShutdown();
    }

    @Test
    public void onCloseShouldSucceedWhenActivityOpened() throws Exception {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        a.onClose();
        ((PlaceManager)Mockito.verify((Object)this.getPlaceManager())).executeOnCloseCallbacks(a.getPlace());
    }

    @Test(expected=IllegalStateException.class)
    public void onCloseShouldFailWhenActivityNotStarted() {
        this.getActivityUnderTest().onClose();
    }

    @Test(expected=IllegalStateException.class)
    public void onCloseShouldFailWhenActivityNotOpen() {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onClose();
    }

    @Test(expected=IllegalStateException.class)
    public void onCloseShouldFailWhenActivityAlreadyClosed() {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        a.onClose();
        a.onClose();
    }

    @Test(expected=IllegalStateException.class)
    public void onShutdownShouldFailWhenActivityNotStarted() {
        this.getActivityUnderTest().onShutdown();
    }

    @Test(expected=IllegalStateException.class)
    public void onShutdownShouldFailWhenActivityOpen() {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        a.onShutdown();
    }

    @Test
    public void fullLifecycleShouldSucceed() throws Exception {
        Activity a = this.getActivityUnderTest();
        a.onStartup((PlaceRequest)new DefaultPlaceRequest("testplace"));
        a.onOpen();
        a.onClose();
        a.onShutdown();
    }
}

