/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.AbstractActivityTest;
import org.uberfire.client.mvp.AbstractPopupActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.popup.PopupView;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractPopupActivityTest
extends AbstractActivityTest {
    @Mock
    IsWidget popupWidget;
    @Mock
    PlaceManager placeManager;
    @Mock
    PopupView popupView;
    TestingPopupActivity popupActivity;
    CloseHandler<PopupView> registeredCloseHandler;
    HandlerRegistration closeHandlerRegistration;
    private PlaceRequest popupPlace;

    @Before
    public void setup() {
        Mockito.when((Object)this.popupView.addCloseHandler((CloseHandler)ArgumentMatchers.any(CloseHandler.class))).thenAnswer((Answer)new Answer<HandlerRegistration>(){

            public HandlerRegistration answer(InvocationOnMock invocation) throws Throwable {
                AbstractPopupActivityTest.this.registeredCloseHandler = (CloseHandler)invocation.getArguments()[0];
                AbstractPopupActivityTest.this.closeHandlerRegistration = (HandlerRegistration)Mockito.mock(HandlerRegistration.class);
                return AbstractPopupActivityTest.this.closeHandlerRegistration;
            }
        });
        this.popupActivity = new TestingPopupActivity(this.placeManager, this.popupView);
        this.popupPlace = new DefaultPlaceRequest("PopupPlace");
    }

    @Override
    public Activity getActivityUnderTest() {
        return this.popupActivity;
    }

    @Override
    public PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    @Test
    public void shouldShowViewInOnOpen() throws Exception {
        this.popupActivity.onStartup(this.popupPlace);
        this.popupActivity.onOpen();
        ((PopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).show();
    }

    @Test
    public void shouldUsePlaceManagerToCloseSelfOnViewClosedCallback() throws Exception {
        this.popupActivity.onStartup(this.popupPlace);
        this.popupActivity.onOpen();
        this.registeredCloseHandler.onClose((CloseEvent)Mockito.mock(CloseEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace(this.popupPlace);
    }

    @Test
    public void shouldCloseViewInOnClose() throws Exception {
        this.popupActivity.onStartup(this.popupPlace);
        this.popupActivity.onOpen();
        this.popupActivity.onClose();
        ((PopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void shouldNotCallHideOnViewWhenCloseOperationTriggeredByView() throws Exception {
        ((PlaceManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AbstractPopupActivityTest.this.popupActivity.onClose();
                return null;
            }
        }).when((Object)this.placeManager)).closePlace(this.popupPlace);
        this.popupActivity.onStartup(this.popupPlace);
        this.popupActivity.onOpen();
        this.registeredCloseHandler.onClose((CloseEvent)Mockito.mock(CloseEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace(this.popupPlace);
        ((PopupView)Mockito.verify((Object)this.popupView, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void shouldNotCallCloseOnPlaceManagerWhenCloseOperationTriggeredByPlaceManager() throws Exception {
        ((PopupView)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                AbstractPopupActivityTest.this.registeredCloseHandler.onClose((CloseEvent)Mockito.mock(CloseEvent.class));
                return null;
            }
        }).when((Object)this.popupView)).hide();
        this.popupActivity.onStartup(this.popupPlace);
        this.popupActivity.onOpen();
        this.popupActivity.onClose();
        ((PopupView)Mockito.verify((Object)this.popupView)).hide();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).closePlace(this.popupPlace);
    }

    private final class TestingPopupActivity
    extends AbstractPopupActivity {
        public TestingPopupActivity(PlaceManager placeManager, PopupView popupView) {
            super(placeManager, popupView);
        }

        public IsWidget getWidget() {
            return AbstractPopupActivityTest.this.popupWidget;
        }

        public String getTitle() {
            return "Testing Popup Activity";
        }

        public String getIdentifier() {
            return "fake.popup.Activity";
        }
    }
}

