/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.util.GWTEditorNativeRegister;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.events.NewWorkbenchScreenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.category.Undefined;

@RunWith(value=MockitoJUnitRunner.class)
public class CategoriesManagerCacheTest {
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    @Mock
    private Event<NewWorkbenchScreenEvent> newWorkbenchScreenEvent;
    private CategoriesManagerCache categoriesManagerCache;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    @Mock
    private GWTEditorNativeRegister gwtEditorNativeRegister;
    private ResourceTypeManagerCache resourceTypeManagerCache;
    private ActivityBeansCache activityBeansCache;
    private Undefined undefinedCategory;

    @Before
    public void setUp() {
        this.categoriesManagerCache = new CategoriesManagerCache(this.undefinedCategory);
        this.resourceTypeManagerCache = new ResourceTypeManagerCache(this.categoriesManagerCache);
        this.activityBeansCache = new ActivityBeansCache(this.iocManager, this.newPerspectiveEventEvent, this.newWorkbenchScreenEvent, this.resourceTypeManagerCache, this.experimentalActivitiesAuthorizationManager, this.gwtEditorNativeRegister);
    }

    @Test
    public void testAvailableCategories() {
        Category process = (Category)Mockito.mock(Category.class);
        Category model = (Category)Mockito.mock(Category.class);
        ClientResourceType clientResourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        Mockito.when((Object)clientResourceType.getCategory()).thenReturn((Object)model);
        SyncBeanDef syncBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)syncBeanDef.getInstance()).thenReturn((Object)clientResourceType);
        List<SyncBeanDef> resourceTypeBeans = Arrays.asList(syncBeanDef);
        Mockito.when((Object)this.iocManager.lookupBeans((String)ArgumentMatchers.eq((Object)"java"))).thenReturn(resourceTypeBeans);
        SyncBeanDef mock = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)"java");
        this.activityBeansCache.addNewEditorActivity(mock, "1", "java");
        Set categories = this.categoriesManagerCache.getCategories();
        Assert.assertTrue((boolean)categories.stream().anyMatch(category -> category.equals((Object)model)));
        Assert.assertTrue((boolean)categories.stream().noneMatch(category -> category.equals((Object)process)));
    }
}

