/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.authz;

import java.util.Arrays;
import java.util.Collections;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultAuthorizationManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=MockitoJUnitRunner.class)
public class MenuBuilderAuthzTest {
    @Mock
    User user;
    @Spy
    MenuVisitor menuVisitor = new CustomVisitor();
    Menus menus;
    AuthFilterMenuVisitor authzVisitor;
    AuthorizationManager authorizationManager;
    PermissionManager permissionManager;

    @Before
    public void setUp() {
        Mockito.when((Object)this.user.getRoles()).thenReturn(Collections.singleton(new RoleImpl("admin")));
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)"Group1").withPermission("group1")).withItems(Arrays.asList((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"Perspective 1").perspective("perspective1")).endMenu()).build().getItems().get(0), (MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"Perspective 2").perspective("perspective2")).endMenu()).build().getItems().get(0))).endMenu()).build();
        this.permissionManager = new DefaultPermissionManager();
        this.authorizationManager = new DefaultAuthorizationManager(this.permissionManager);
        this.authzVisitor = (AuthFilterMenuVisitor)Mockito.spy((Object)new AuthFilterMenuVisitor(this.authorizationManager, this.user, this.menuVisitor));
    }

    @Test
    public void testVisit() {
        this.menus.accept((MenuVisitor)this.authzVisitor);
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor)).visitEnter((MenuGroup)Mockito.any(MenuGroup.class));
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.times((int)2))).visit((MenuItemPerspective)Mockito.any(MenuItemPerspective.class));
    }

    @Test
    public void testVisit2() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").permission("perspective.read.perspective1", Boolean.valueOf(false)).build());
        this.menus.accept((MenuVisitor)this.authzVisitor);
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor)).visitEnter((MenuGroup)Mockito.any(MenuGroup.class));
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.times((int)1))).visit((MenuItemPerspective)Mockito.any(MenuItemPerspective.class));
    }

    @Test
    public void testVisit3() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").permission("perspective.read.perspective1", Boolean.valueOf(false)).permission("perspective.read.perspective2", Boolean.valueOf(false)).build());
        this.menus.accept((MenuVisitor)this.authzVisitor);
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visitEnter((MenuGroup)Mockito.any(MenuGroup.class));
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visit((MenuItemPerspective)Mockito.any(MenuItemPerspective.class));
    }

    @Test
    public void testVisit4() {
        Menus menus = ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)"Group").withItems(Arrays.asList((MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"Perspective 1").withPermission("perspective.read.perspective1")).endMenu()).build().getItems().get(0), (MenuItem)((MenuFactory.Builder)((MenuFactory.MenuBuilder)MenuFactory.newSimpleItem((String)"Perspective 2").withPermission("perspective.read.perspective2")).endMenu()).build().getItems().get(0))).endMenu()).build();
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").permission("perspective.read.perspective1", Boolean.valueOf(false)).permission("perspective.read.perspective2", Boolean.valueOf(false)).build());
        menus.accept((MenuVisitor)this.authzVisitor);
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visitEnter((MenuGroup)Mockito.any(MenuGroup.class));
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visit((MenuItemPerspective)Mockito.any(MenuItemPerspective.class));
    }

    @Test
    public void testVisit5() {
        this.permissionManager.setAuthorizationPolicy(this.permissionManager.newAuthorizationPolicy().role("admin").permission("group1", Boolean.valueOf(false)).build());
        this.menus.accept((MenuVisitor)this.authzVisitor);
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visitEnter((MenuGroup)Mockito.any(MenuGroup.class));
        ((MenuVisitor)Mockito.verify((Object)this.menuVisitor, (VerificationMode)Mockito.never())).visit((MenuItemPerspective)Mockito.any(MenuItemPerspective.class));
    }

    private class CustomVisitor
    implements MenuVisitor {
        private CustomVisitor() {
        }

        public boolean visitEnter(Menus menus) {
            return true;
        }

        public void visitLeave(Menus menus) {
        }

        public boolean visitEnter(MenuGroup menuGroup) {
            return true;
        }

        public void visitLeave(MenuGroup menuGroup) {
        }

        public void visit(MenuItemPlain menuItemPlain) {
        }

        public void visit(MenuItemCommand menuItemCommand) {
        }

        public void visit(MenuItemPerspective menuItemPerspective) {
        }

        public void visit(MenuCustom<?> menuCustom) {
        }
    }
}

