/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.CategoriesManagerCache;
import org.uberfire.client.mvp.ResourceTypeManagerCache;
import org.uberfire.client.util.GWTEditorNativeRegister;
import org.uberfire.client.workbench.events.NewPerspectiveEvent;
import org.uberfire.client.workbench.events.NewWorkbenchScreenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.experimental.service.auth.ExperimentalActivitiesAuthorizationManager;
import org.uberfire.workbench.category.Category;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class ResourceTypeManagerCacheTest {
    public static final String MODEL_CATEGORY = "MODEL";
    public static final String MODEL_TYPE = "java";
    public static final String FORM_CATEGORY = "FORM";
    public static final String FORM_TYPE = "frm";
    public static final String ANY_RESOURCE = "any.resource";
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private Event<NewPerspectiveEvent> newPerspectiveEventEvent;
    @Mock
    private Event<NewWorkbenchScreenEvent> newWorkbenchScreenEvent;
    @Mock
    private CategoriesManagerCache categoriesManagerCache;
    private ResourceTypeManagerCache resourceTypeManagerCache;
    @Mock
    private ExperimentalActivitiesAuthorizationManager experimentalActivitiesAuthorizationManager;
    @Mock
    private GWTEditorNativeRegister gwtEditorNativeRegister;
    private ActivityBeansCache activityBeansCache;
    private EditorDef defaultEditorDef;
    private EditorDef modelEditorDef;
    private EditorDef formEditorDef;
    private List<Class> experimentalTestActivities = new ArrayList<Class>();

    @Before
    public void setUp() {
        this.experimentalTestActivities.add(ModelEditorActivity.class);
        this.experimentalTestActivities.add(FormEditorActivity.class);
        this.experimentalTestActivities.add(DefaultEditorActivity.class);
        Mockito.when((Object)this.experimentalActivitiesAuthorizationManager.authorizeActivityClass((Class)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                Class type = (Class)invocationOnMock.getArguments()[0];
                return ResourceTypeManagerCacheTest.this.experimentalTestActivities.contains(type);
            }
        });
        this.resourceTypeManagerCache = new ResourceTypeManagerCache(this.categoriesManagerCache);
        this.activityBeansCache = new ActivityBeansCache(this.iocManager, this.newPerspectiveEventEvent, this.newWorkbenchScreenEvent, this.resourceTypeManagerCache, this.experimentalActivitiesAuthorizationManager, this.gwtEditorNativeRegister);
        this.modelEditorDef = this.registerResourceType(MODEL_CATEGORY, ModelEditorActivity.class, MODEL_TYPE, "1");
        this.formEditorDef = this.registerResourceType(FORM_CATEGORY, FormEditorActivity.class, FORM_TYPE, "2");
    }

    private void registerDefaultResourceType() {
        ClientResourceType anyResourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        Mockito.when((Object)anyResourceType.accept((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        this.defaultEditorDef = this.registerResourceType(anyResourceType, DefaultEditorActivity.class, "", "-1", null);
    }

    private EditorDef registerResourceType(ClientResourceType resourceType, Class<?> editorActivityClass, String type, String priority, Category category) {
        SyncBeanDef typeBeanDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)((ClientResourceType)typeBeanDef.getInstance())).thenReturn((Object)resourceType);
        List<SyncBeanDef> resourceTypeBeans = Arrays.asList(typeBeanDef);
        Mockito.when((Object)this.iocManager.lookupBeans((String)ArgumentMatchers.eq((Object)type))).thenReturn(resourceTypeBeans);
        SyncBeanDef editorActivityDef = (SyncBeanDef)Mockito.mock(SyncBeanDef.class);
        Mockito.when((Object)editorActivityDef.getBeanClass()).thenReturn(editorActivityClass);
        Mockito.when((Object)editorActivityDef.getName()).thenReturn((Object)type);
        this.activityBeansCache.addNewEditorActivity(editorActivityDef, priority, type);
        return new EditorDef(editorActivityDef, resourceType, category);
    }

    private EditorDef registerResourceType(String categoryName, Class<?> editorActivityClass, String type, String priority) {
        Category category = (Category)Mockito.mock(Category.class);
        ClientResourceType resourceType = (ClientResourceType)Mockito.mock(ClientResourceType.class);
        Mockito.when((Object)resourceType.getCategory()).thenReturn((Object)category);
        Mockito.when((Object)resourceType.accept((Path)ArgumentMatchers.any(Path.class))).thenAnswer(invocationOnMock -> {
            Path path = (Path)invocationOnMock.getArguments()[0];
            return path.getFileName().endsWith(type);
        });
        return this.registerResourceType(resourceType, editorActivityClass, type, priority, category);
    }

    @Test
    public void testGetResourceTypeDefinitions() {
        Category process = (Category)Mockito.mock(Category.class);
        Assertions.assertThat((List)this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(process)).isEmpty();
        ((ListAssert)Assertions.assertThat((List)this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(this.modelEditorDef.getCategory())).hasSize(1)).containsExactly((Object[])new ResourceTypeDefinition[]{this.modelEditorDef.getResourceType()});
        ((ListAssert)Assertions.assertThat((List)this.resourceTypeManagerCache.getResourceTypeDefinitionsByCategory(this.formEditorDef.getCategory())).hasSize(1)).containsExactly((Object[])new ResourceTypeDefinition[]{this.formEditorDef.getResourceType()});
    }

    @Test
    public void testGetUnknownEditorByPathWithoutDefaultEditor() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)ANY_RESOURCE);
        Assertions.assertThatThrownBy(() -> this.activityBeansCache.getActivity(path)).isInstanceOf(ActivityBeansCache.EditorResourceTypeNotFound.class);
    }

    @Test
    public void testGetUnknownEditorByPathWithDefaultEditor() {
        this.registerDefaultResourceType();
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)ANY_RESOURCE);
        ((ObjectAssert)Assertions.assertThat((Object)this.activityBeansCache.getActivity(path)).isNotNull()).isEqualTo((Object)this.defaultEditorDef.getEditorActivityBeanDef());
    }

    @Test
    public void testGetEditorByPath() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"any.java");
        ((ObjectAssert)Assertions.assertThat((Object)this.activityBeansCache.getActivity(path)).isNotNull()).isEqualTo((Object)this.modelEditorDef.getEditorActivityBeanDef());
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"any.frm");
        ((ObjectAssert)Assertions.assertThat((Object)this.activityBeansCache.getActivity(path)).isNotNull()).isEqualTo((Object)this.formEditorDef.getEditorActivityBeanDef());
    }

    @Test
    public void testGetDefaultEditoFromDisabledExperimentalEditorByPath() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"any.frm");
        this.registerDefaultResourceType();
        this.experimentalTestActivities.remove(FormEditorActivity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.activityBeansCache.getActivity(path)).isNotNull()).isEqualTo((Object)this.defaultEditorDef.getEditorActivityBeanDef());
    }

    private class DefaultEditorActivity {
        private DefaultEditorActivity() {
        }
    }

    private class FormEditorActivity {
        private FormEditorActivity() {
        }
    }

    private class ModelEditorActivity {
        private ModelEditorActivity() {
        }
    }

    public class EditorDef {
        private SyncBeanDef editorActivity;
        private ClientResourceType resourceType;
        private Category category;

        public EditorDef(SyncBeanDef editorActivity, ClientResourceType resourceType, Category category) {
            this.editorActivity = editorActivity;
            this.resourceType = resourceType;
            this.category = category;
        }

        public SyncBeanDef getEditorActivityBeanDef() {
            return this.editorActivity;
        }

        public ClientResourceType getResourceType() {
            return this.resourceType;
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

