/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.ContextActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.ContextDefinition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.ContextDefinitionImpl;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

public abstract class AbstractWorkbenchPanelPresenterTest {
    protected final PerspectiveDefinition panelManagerPerspectiveDefinition = new PerspectiveDefinitionImpl();
    protected final PartDefinition partPresenterPartDefinition = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("belongs_to_mockPartPresenter"));
    protected final PanelDefinition panelPresenterPanelDefinition = new PanelDefinitionImpl();
    protected final ContextDefinition perspectiveContextDefinition = new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("Perspective Context"));
    @Mock
    protected PerspectiveManager mockPerspectiveManager;
    @Mock
    protected ActivityManager mockActivityManager;
    @Mock
    protected WorkbenchPartPresenter.View mockPartView;
    @Mock
    protected WorkbenchPartPresenter mockPartPresenter;
    @Mock
    protected ContextActivity perspectiveContextActivity;

    abstract WorkbenchPanelPresenter getPresenterToTest();

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockPerspectiveManager.getLivePerspectiveDefinition()).thenReturn((Object)this.panelManagerPerspectiveDefinition);
        this.panelManagerPerspectiveDefinition.setContextDefinition(this.perspectiveContextDefinition);
        Mockito.when((Object)((ContextActivity)this.mockActivityManager.getActivity(ContextActivity.class, this.perspectiveContextDefinition.getPlace()))).thenReturn((Object)this.perspectiveContextActivity);
        Mockito.when((Object)this.mockPartView.getPresenter()).thenReturn((Object)this.mockPartPresenter);
        Mockito.when((Object)this.mockPartPresenter.getDefinition()).thenReturn((Object)this.partPresenterPartDefinition);
    }

    @Test
    public void addingPartShouldUpdateDefinition() throws Exception {
        WorkbenchPanelPresenter panelPresenter = this.getPresenterToTest();
        try {
            panelPresenter.addPart(this.mockPartPresenter);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertSame((Object)panelPresenter.getDefinition(), (Object)this.mockPartPresenter.getDefinition().getParentPanel());
        Assert.assertTrue((boolean)panelPresenter.getDefinition().getParts().contains(this.mockPartPresenter.getDefinition()));
    }

    @Test
    public void removingPartShouldUpdateDefinition() throws Exception {
        WorkbenchPanelPresenter panelPresenter = this.getPresenterToTest();
        try {
            panelPresenter.addPart(this.mockPartPresenter);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        panelPresenter.removePart(this.mockPartPresenter.getDefinition());
        Assert.assertNull((Object)this.mockPartPresenter.getDefinition().getParentPanel());
        Assert.assertFalse((boolean)panelPresenter.getDefinition().getParts().contains(this.mockPartPresenter.getDefinition()));
    }

    @Test
    public void addingPartThatIsAlreadyInPanelDefShouldNotChangePanelDef() throws Exception {
        WorkbenchPanelPresenter panelPresenter = this.getPresenterToTest();
        panelPresenter.getDefinition().addPart(this.partPresenterPartDefinition);
        Assert.assertEquals((long)1L, (long)panelPresenter.getDefinition().getParts().size());
        try {
            panelPresenter.addPart(this.mockPartPresenter);
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        Assert.assertSame((Object)panelPresenter.getDefinition(), (Object)this.mockPartPresenter.getDefinition().getParentPanel());
        Assert.assertTrue((boolean)panelPresenter.getDefinition().getParts().contains(this.mockPartPresenter.getDefinition()));
        Assert.assertEquals((long)1L, (long)panelPresenter.getDefinition().getParts().size());
    }
}

