/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgroups.util.Util;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.impl.SinglePartPanelHelper;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PartDefinition;

@RunWith(value=MockitoJUnitRunner.class)
public class SinglePartPanelHelperTest {
    private SinglePartPanelHelper singlePartHelper;
    @Mock
    private PlaceManager placeManager;

    @Test
    public void thereIsNoPartsTest() {
        this.singlePartHelper = new SinglePartPanelHelper(new ArrayList(), this.placeManager);
        Util.assertTrue((boolean)this.singlePartHelper.hasNoParts());
    }

    @Test
    public void getPlaceFromFirstPartTest() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        PartDefinition part = (PartDefinition)Mockito.mock(PartDefinition.class);
        Mockito.when((Object)part.getPlace()).thenReturn((Object)place);
        List<PartDefinition> parts = Arrays.asList(part);
        this.singlePartHelper = new SinglePartPanelHelper(parts, this.placeManager);
        Util.assertTrue((!this.singlePartHelper.hasNoParts() ? 1 : 0) != 0);
        Util.assertEquals((Object)place, (Object)this.singlePartHelper.getPlaceFromFirstPart());
    }

    @Test
    public void closeFirstPartAndAddNewOneTest() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        PartDefinition part = (PartDefinition)Mockito.mock(PartDefinition.class);
        Command cmd = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)part.getPlace()).thenReturn((Object)place);
        List<PartDefinition> parts = Arrays.asList(part);
        this.singlePartHelper = new SinglePartPanelHelper(parts, this.placeManager);
        this.singlePartHelper.closeFirstPartAndAddNewOne(cmd);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).tryClosePlace(place, cmd);
    }
}

