/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.workingset.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.guvnor.common.services.workingset.client.events.OnWorkingSetApplied;
import org.guvnor.common.services.workingset.client.events.OnWorkingSetDisabled;
import org.guvnor.common.services.workingset.client.factconstraints.ConstraintConfiguration;
import org.guvnor.common.services.workingset.client.factconstraints.customform.CustomFormConfiguration;
import org.guvnor.common.services.workingset.client.factconstraints.helper.CustomFormsContainer;
import org.guvnor.common.services.workingset.client.model.WorkingSetConfigData;
import org.guvnor.common.services.workingset.client.model.WorkingSetSettings;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class WorkingSetManager {
    private Map<Path, WorkingSetSettings> projectSettings = new HashMap<Path, WorkingSetSettings>();
    @Inject
    private Caller<ModuleService<? super Module>> moduleServiceCaller;
    private boolean autoVerifierEnabled = false;

    public void onWorkingSetApplied(@Observes OnWorkingSetApplied event) {
    }

    public void onWorkingSetDisabled(@Observes OnWorkingSetDisabled event) {
        WorkingSetSettings settings = this.getActiveSettings(event.getResource());
        if (settings != null) {
            settings.removeWorkingSet(event.getWorkingSet());
        }
    }

    public Collection<WorkingSetConfigData> getActiveWorkingSets(Path resource) {
        WorkingSetSettings result = this.getActiveSettings(resource);
        if (result == null) {
            return null;
        }
        return result.getConfigData();
    }

    public WorkingSetSettings getActiveSettings(Path resource) {
        return null;
    }

    public void removeWorkingSets(Path resource) {
    }

    public boolean isWorkingSetActive(Path resource, Path workingSet) {
        WorkingSetSettings result = this.getActiveSettings(resource);
        if (result == null) {
            return false;
        }
        return result.getResources().contains(workingSet);
    }

    public Set<ConstraintConfiguration> getFieldContraints(Path resource, String factType, String fieldName) {
        HashSet<ConstraintConfiguration> result = new HashSet<ConstraintConfiguration>();
        Collection<WorkingSetConfigData> activeConfig = this.getActiveWorkingSets(resource);
        if (activeConfig != null) {
            for (WorkingSetConfigData configData : activeConfig) {
                List constraints = configData.getConstraints();
                if (constraints == null) continue;
                for (ConstraintConfiguration constraint : constraints) {
                    if (!constraint.getFactType().equals(factType) || !constraint.getFieldName().equals(fieldName)) continue;
                    result.add(constraint);
                }
            }
        }
        return result;
    }

    public boolean isAutoVerifierEnabled() {
        return this.autoVerifierEnabled;
    }

    public void setAutoVerifierEnabled(boolean autoVerifierEnabled) {
        this.autoVerifierEnabled = autoVerifierEnabled;
    }

    public CustomFormConfiguration getCustomFormConfiguration(Path resource, String factType, String fieldName) {
        Collection<WorkingSetConfigData> packageWorkingSets = this.getActiveWorkingSets(resource);
        if (packageWorkingSets != null) {
            ArrayList configs = new ArrayList();
            for (WorkingSetConfigData workingSetConfigData : packageWorkingSets) {
                if (workingSetConfigData.getCustomForms() == null || workingSetConfigData.getCustomForms().isEmpty()) continue;
                configs.addAll(workingSetConfigData.getCustomForms());
            }
            CustomFormsContainer cfc = new CustomFormsContainer(configs);
            if (cfc.containsCustomFormFor(factType, fieldName)) {
                return cfc.getCustomForm(factType, fieldName);
            }
        }
        return null;
    }
}

