/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb;

import java.io.OutputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorException;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorStreamFactory;

public enum Compression {
    NONE(""),
    GZIP(".gz"),
    BZIP2(".bz2"),
    XZ(".xz");

    private String extension;

    private Compression(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public OutputStream toCompressedOutputStream(OutputStream out) throws CompressorException {
        switch (this) {
            case GZIP: {
                return new CompressorStreamFactory().createCompressorOutputStream("gz", out);
            }
            case BZIP2: {
                return new CompressorStreamFactory().createCompressorOutputStream("bzip2", out);
            }
            case XZ: {
                return new CompressorStreamFactory().createCompressorOutputStream("xz", out);
            }
        }
        return out;
    }

    public static Compression toEnum(String name) {
        if ("gzip".equalsIgnoreCase(name) || "gz".equalsIgnoreCase(name)) {
            return GZIP;
        }
        if ("bzip2".equalsIgnoreCase(name) || "bz2".equalsIgnoreCase(name)) {
            return BZIP2;
        }
        if ("xz".equalsIgnoreCase(name)) {
            return XZ;
        }
        if ("none".equalsIgnoreCase(name)) {
            return NONE;
        }
        return null;
    }
}

