/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.debian;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.vafer.jdeb.debian.ControlField;
import org.vafer.jdeb.debian.ControlFile;

public final class BinaryPackageControlFile
extends ControlFile {
    private static final ControlField[] FIELDS = new ControlField[]{new ControlField("Package", true), new ControlField("Source"), new ControlField("Version", true), new ControlField("Section", true), new ControlField("Priority", true), new ControlField("Architecture", true), new ControlField("Essential"), new ControlField("Depends"), new ControlField("Pre-Depends"), new ControlField("Recommends"), new ControlField("Suggests"), new ControlField("Breaks"), new ControlField("Enhances"), new ControlField("Conflicts"), new ControlField("Provides"), new ControlField("Replaces"), new ControlField("Installed-Size"), new ControlField("Maintainer", true), new ControlField("Description", true, ControlField.Type.MULTILINE), new ControlField("Homepage")};

    public BinaryPackageControlFile() {
        this.set("Architecture", "all");
        this.set("Priority", "optional");
    }

    public BinaryPackageControlFile(String input) throws IOException, ParseException {
        this.parse(input);
    }

    public BinaryPackageControlFile(InputStream input) throws IOException, ParseException {
        this.parse(input);
    }

    @Override
    public void set(String field, String value) {
        super.set(field, value);
    }

    @Override
    protected ControlField[] getFields() {
        return FIELDS;
    }

    public String getShortDescription() {
        if (this.get("Description") == null) {
            return null;
        }
        return this.get("Description").split("\n")[0];
    }

    @Override
    protected char getUserDefinedFieldLetter() {
        return 'B';
    }
}

