/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.math.ec;

import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.math.ec.AbstractECMultiplier;
import org.vafer.jdeb.shaded.bc.math.ec.ECCurve;
import org.vafer.jdeb.shaded.bc.math.ec.ECPoint;
import org.vafer.jdeb.shaded.bc.math.ec.PreCompInfo;
import org.vafer.jdeb.shaded.bc.math.ec.Tnaf;
import org.vafer.jdeb.shaded.bc.math.ec.WTauNafPreCompInfo;
import org.vafer.jdeb.shaded.bc.math.ec.ZTauElement;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    static final String PRECOMP_NAME = "bc_wtnaf";

    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!(eCPoint instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m f2m = (ECPoint.F2m)eCPoint;
        ECCurve.F2m f2m2 = (ECCurve.F2m)f2m.getCurve();
        int n = f2m2.getM();
        byte by = f2m2.getA().toBigInteger().byteValue();
        byte by2 = f2m2.getMu();
        BigInteger[] bigIntegerArray = f2m2.getSi();
        ZTauElement zTauElement = Tnaf.partModReduction(bigInteger, n, by, bigIntegerArray, by2, (byte)10);
        return this.multiplyWTnaf(f2m, zTauElement, f2m2.getPreCompInfo(f2m, PRECOMP_NAME), by, by2);
    }

    private ECPoint.F2m multiplyWTnaf(ECPoint.F2m f2m, ZTauElement zTauElement, PreCompInfo preCompInfo, byte by, byte by2) {
        ZTauElement[] zTauElementArray = by == 0 ? Tnaf.alpha0 : Tnaf.alpha1;
        BigInteger bigInteger = Tnaf.getTw(by2, 4);
        byte[] byArray = Tnaf.tauAdicWNaf(by2, zTauElement, (byte)4, BigInteger.valueOf(16L), bigInteger, zTauElementArray);
        return WTauNafMultiplier.multiplyFromWTnaf(f2m, byArray, preCompInfo);
    }

    private static ECPoint.F2m multiplyFromWTnaf(ECPoint.F2m f2m, byte[] byArray, PreCompInfo preCompInfo) {
        Object object;
        ECPoint.F2m[] f2mArray;
        ECCurve.F2m f2m2 = (ECCurve.F2m)f2m.getCurve();
        byte by = f2m2.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            f2mArray = Tnaf.getPreComp(f2m, by);
            object = new WTauNafPreCompInfo();
            ((WTauNafPreCompInfo)object).setPreComp(f2mArray);
            f2m2.setPreCompInfo(f2m, PRECOMP_NAME, (PreCompInfo)object);
        } else {
            f2mArray = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        object = (ECPoint.F2m)f2m.getCurve().getInfinity();
        for (int i = byArray.length - 1; i >= 0; --i) {
            object = Tnaf.tau((ECPoint.F2m)object);
            byte by2 = byArray[i];
            if (by2 == 0) continue;
            object = by2 > 0 ? ((ECPoint.F2m)object).addSimple(f2mArray[by2]) : ((ECPoint.F2m)object).subtractSimple(f2mArray[-by2]);
        }
        return object;
    }
}

