/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.vafer.jdeb.shaded.bc.bcpg.SignaturePacket;
import org.vafer.jdeb.shaded.bc.bcpg.SignatureSubpacket;
import org.vafer.jdeb.shaded.bc.bcpg.sig.Features;
import org.vafer.jdeb.shaded.bc.bcpg.sig.IssuerKeyID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.KeyExpirationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.KeyFlags;
import org.vafer.jdeb.shaded.bc.bcpg.sig.NotationData;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PreferredAlgorithms;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PrimaryUserID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureCreationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureExpirationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignerUserID;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureList;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    PGPSignatureSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        this.packets = signatureSubpacketArray;
    }

    public SignatureSubpacket getSubpacket(int n) {
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != n) continue;
            return this.packets[i];
        }
        return null;
    }

    public boolean hasSubpacket(int n) {
        return this.getSubpacket(n) != null;
    }

    public SignatureSubpacket[] getSubpackets(int n) {
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>();
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != n) continue;
            arrayList.add(this.packets[i]);
        }
        return arrayList.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureList getEmbeddedSignatures() throws PGPException {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(32);
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        for (int i = 0; i < signatureSubpacketArray.length; ++i) {
            try {
                arrayList.add(new PGPSignature(SignaturePacket.fromByteArray(signatureSubpacketArray[i].getData())));
                continue;
            }
            catch (IOException iOException) {
                throw new PGPException("Unable to parse signature packet: " + iOException.getMessage(), iOException);
            }
        }
        return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
    }

    public NotationData[] getNotationDataOccurrences() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(20);
        NotationData[] notationDataArray = new NotationData[signatureSubpacketArray.length];
        for (int i = 0; i < signatureSubpacketArray.length; ++i) {
            notationDataArray[i] = (NotationData)signatureSubpacketArray[i];
        }
        return notationDataArray;
    }

    public NotationData[] getNotationDataOccurences() {
        return this.getNotationDataOccurrences();
    }

    public long getIssuerKeyID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(16);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((IssuerKeyID)signatureSubpacket).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(2);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignatureCreationTime)signatureSubpacket).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(3);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)signatureSubpacket).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(9);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((KeyExpirationTime)signatureSubpacket).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(21);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(11);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(22);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(27);
        if (signatureSubpacket == null) {
            return 0;
        }
        return ((KeyFlags)signatureSubpacket).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(28);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignerUserID)signatureSubpacket).getID();
    }

    public boolean isPrimaryUserID() {
        PrimaryUserID primaryUserID = (PrimaryUserID)this.getSubpacket(25);
        if (primaryUserID != null) {
            return primaryUserID.isPrimaryUserID();
        }
        return false;
    }

    public int[] getCriticalTags() {
        int n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            nArray[n++] = this.packets[i].getType();
        }
        return nArray;
    }

    public Features getFeatures() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(30);
        if (signatureSubpacket == null) {
            return null;
        }
        return new Features(signatureSubpacket.isCritical(), signatureSubpacket.getData());
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }
}

