/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.maven.plugin.report;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.whitesource.agent.api.dispatch.ReportRequest;
import org.whitesource.agent.api.dispatch.ReportResult;
import org.whitesource.agent.api.model.DependencyInfo;
import org.whitesource.agent.maven.plugin.InputValidator;
import org.whitesource.agent.maven.plugin.WssServiceProvider;
import org.whitesource.agent.maven.plugin.report.ReportRenderer;
import org.whitesource.api.client.WssServiceException;

public class ReportMojo
extends AbstractMojo {
    private MavenProject project = null;
    protected File outputDirectory;
    private boolean skip;
    private boolean failOnError;
    private boolean generateReport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping White Source license report");
        } else {
            try {
                this.doExecute();
            }
            catch (MojoExecutionException e) {
                this.handleError((Exception)((Object)e));
            }
            finally {
                WssServiceProvider.instance().shutdown();
            }
        }
    }

    private void doExecute() throws MojoExecutionException {
        this.validateInputs(this.project);
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        this.processProject(this.project, dependencies);
        this.processChildren(this.project, dependencies);
        if (dependencies.isEmpty()) {
            this.getLog().info((CharSequence)"No dependencies were found");
        } else {
            ReportResult result = this.getReport(dependencies);
            ReportRenderer.renderToLog(result, this.getLog());
            if (this.generateReport) {
                this.getLog().info((CharSequence)("White Source report directory: " + this.outputDirectory.getAbsolutePath()));
                try {
                    ReportRenderer.renderToXML(this.outputDirectory, result);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to generate report", (Exception)e);
                }
            }
        }
    }

    private ReportResult getReport(Collection<DependencyInfo> dependencies) throws MojoExecutionException {
        ReportResult result = null;
        try {
            ReportRequest request = WssServiceProvider.instance().requestFactory().newReportRequest(dependencies);
            result = WssServiceProvider.instance().provider().getReport(request);
        }
        catch (WssServiceException e) {
            throw new MojoExecutionException("Error getting report", (Exception)((Object)e));
        }
        return result;
    }

    private void processProject(MavenProject project, Set<DependencyInfo> dependencies) {
        for (Artifact artifact : project.getArtifacts()) {
            dependencies.add(ReportMojo.getDependencyInfo(artifact));
        }
    }

    public static DependencyInfo getDependencyInfo(Artifact artifact) {
        DependencyInfo info = new DependencyInfo();
        info.setGroupId(artifact.getGroupId());
        info.setArtifactId(artifact.getArtifactId());
        info.setVersion(artifact.getVersion());
        info.setScope(artifact.getScope());
        info.setClassifier(artifact.getClassifier());
        info.setOptional(artifact.isOptional());
        info.setType(artifact.getType());
        return info;
    }

    private void processChildren(MavenProject project, Set<DependencyInfo> dependencies) {
        List collectedProjects = project.getCollectedProjects();
        if (collectedProjects != null) {
            for (MavenProject collectedProject : collectedProjects) {
                this.processProject(collectedProject, dependencies);
            }
        }
    }

    private void validateInputs(MavenProject project) throws MojoExecutionException {
        if (project == null) {
            throw new MojoExecutionException("No project found");
        }
        if (InputValidator.isStandAlonePom(project)) {
            throw new MojoExecutionException("Not a project folder");
        }
    }

    private void handleError(Exception e) throws MojoExecutionException {
        String message = e.getMessage();
        if (this.failOnError) {
            throw new MojoExecutionException(message, e);
        }
        this.getLog().warn((CharSequence)message);
        this.getLog().debug((Throwable)e);
    }
}

