/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.maven.plugin.update;

import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.whitesource.agent.api.dispatch.PropertiesRequest;
import org.whitesource.agent.api.dispatch.PropertiesResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.maven.plugin.InputValidator;
import org.whitesource.agent.maven.plugin.WssServiceProvider;
import org.whitesource.agent.maven.plugin.update.UpdaterImpl;
import org.whitesource.api.client.WssServiceException;

public class UpdateMojo
extends AbstractMojo {
    private String orgToken;
    private Collection<MavenProject> projects;
    private boolean failOnError;
    private boolean skip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping White Source update");
        } else {
            try {
                this.doExecute();
            }
            catch (MojoExecutionException e) {
                this.handleError((Exception)((Object)e));
            }
            finally {
                WssServiceProvider.instance().shutdown();
            }
        }
    }

    private void doExecute() throws MojoExecutionException {
        this.validateInputs();
        this.update();
    }

    private void update() throws MojoExecutionException {
        PropertiesResult propertiesResult;
        PropertiesRequest request = WssServiceProvider.instance().requestFactory().newPropertiesRequest(this.orgToken);
        try {
            propertiesResult = WssServiceProvider.instance().provider().getProperties(request);
        }
        catch (WssServiceException e) {
            throw new MojoExecutionException("Error getting properties from WhiteSource", (Exception)((Object)e));
        }
        UpdaterImpl updater = new UpdaterImpl(propertiesResult.getProperties(), this.orgToken, this.projects);
        updater.setLog(this.getLog());
        UpdateInventoryResult result = updater.update();
        this.logResult(result);
    }

    private void logResult(UpdateInventoryResult result) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Inventory update results for organization " + result.getOrganization()));
        Collection updatedProjects = result.getUpdatedProjects();
        if (updatedProjects.isEmpty()) {
            this.getLog().info((CharSequence)"No projects were updated");
        } else {
            this.getLog().info((CharSequence)"The following projects have been updated: ");
            this.getLog().info((CharSequence)"");
            for (String projectName : updatedProjects) {
                this.getLog().info((CharSequence)projectName);
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Each project admin will receive an email once the update process has been completed");
            this.getLog().info((CharSequence)"");
        }
        Collection createdProjects = result.getCreatedProjects();
        if (!createdProjects.isEmpty()) {
            this.getLog().info((CharSequence)"The following projects have been created: ");
            this.getLog().info((CharSequence)"");
            for (String projectName : createdProjects) {
                this.getLog().info((CharSequence)projectName);
            }
        }
    }

    private void validateInputs() throws MojoExecutionException {
        if (this.projects == null || this.projects.isEmpty()) {
            throw new MojoExecutionException("No project found");
        }
        if (InputValidator.isStandAlonePom(this.projects.iterator().next())) {
            throw new MojoExecutionException("Not a project folder");
        }
        if (this.orgToken == null) {
            throw new MojoExecutionException("Token property missing in plugin configuration");
        }
    }

    private void handleError(Exception e) throws MojoExecutionException {
        String message = e.getMessage();
        if (this.failOnError) {
            throw new MojoExecutionException(message, e);
        }
        this.getLog().warn((CharSequence)message);
        this.getLog().debug((Throwable)e);
    }
}

