/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.as.arquillian.container.domain.ArchiveDeployer;
import org.jboss.as.arquillian.container.domain.Authentication;
import org.jboss.as.arquillian.container.domain.CommonDomainContainerConfiguration;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.arquillian.container.domain.ServerContainer;
import org.jboss.as.arquillian.container.domain.ServerGroupContainer;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public abstract class CommonDomainDeployableContainer<T extends CommonDomainContainerConfiguration>
implements DeployableContainer<T> {
    @Inject
    private Instance<ContainerRegistry> containerRegistryInstance;
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    private Instance<Injector> injectorInst;
    @Inject
    private Event<SetupContainer> setupEvent;
    private final Logger log = Logger.getLogger(CommonDomainDeployableContainer.class.getName());
    private T containerConfig;
    private ManagementClient managementClient;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<ManagementClient> managementClientInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<Domain> domainInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(T config) {
        this.containerConfig = config;
    }

    public void start() throws LifecycleException {
        String mode;
        Container serverContainer;
        if (((CommonDomainContainerConfiguration)this.containerConfig).getUsername() != null) {
            Authentication.username = ((CommonDomainContainerConfiguration)this.containerConfig).getUsername();
            Authentication.password = ((CommonDomainContainerConfiguration)this.containerConfig).getPassword();
        }
        DomainClient domainClient = DomainClient.Factory.create((InetAddress)((CommonDomainContainerConfiguration)this.containerConfig).getManagementAddress(), (int)((CommonDomainContainerConfiguration)this.containerConfig).getManagementPort(), (CallbackHandler)Authentication.getCallbackHandler());
        this.managementClient = new ManagementClient((ModelControllerClient)domainClient, ((CommonDomainContainerConfiguration)this.containerConfig).getManagementAddress().getHostAddress(), ((CommonDomainContainerConfiguration)this.containerConfig).getManagementPort());
        this.managementClientInst.set((Object)this.managementClient);
        ArchiveDeployer archiveDeployer = new ArchiveDeployer(domainClient.getDeploymentManager());
        this.archiveDeployerInst.set((Object)archiveDeployer);
        try {
            this.startInternal();
        }
        catch (LifecycleException e) {
            this.safeCloseClient();
            throw e;
        }
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInstance.get();
        Map<String, String> containerNameMap = ((CommonDomainContainerConfiguration)this.containerConfig).getContainerNameMap();
        Map<String, String> modeMap = ((CommonDomainContainerConfiguration)this.containerConfig).getContainerModeMap();
        Domain domain = this.managementClient.createDomain(containerNameMap);
        this.domainInst.set((Object)domain);
        this.waitForStart(domain, this.managementClient);
        for (Domain.ServerGroup serverGroup : domain.getServerGroups()) {
            serverContainer = this.createServerGroupContainer(registry, archiveDeployer, domain, serverGroup, ((CommonDomainContainerConfiguration)this.containerConfig).getServerGroupOperationTimeoutInSeconds());
            mode = this.mapMode(modeMap, serverContainer.getName());
            if (mode != null) {
                serverContainer.getContainerConfiguration().setMode(mode);
            }
            this.setupEvent.fire((Object)new SetupContainer(serverContainer));
            serverContainer.setState(Container.State.STARTED);
        }
        for (Domain.Server server : domain.getServers()) {
            serverContainer = this.createServerContainer(registry, server, ((CommonDomainContainerConfiguration)this.containerConfig).getServerOperationTimeoutInSeconds());
            mode = this.mapMode(modeMap, serverContainer.getName());
            if (mode != null) {
                serverContainer.getContainerConfiguration().setMode(mode);
            }
            String serverStatus = this.managementClient.getServerState(server);
            this.setupEvent.fire((Object)new SetupContainer(serverContainer));
            if (serverStatus.equals("STARTED")) {
                serverContainer.setState(Container.State.STARTED);
                continue;
            }
            serverContainer.setState(Container.State.STOPPED);
        }
    }

    public final void stop() throws LifecycleException {
        try {
            this.stopInternal();
            this.updateDomainMembersState(Container.State.STOPPED);
        }
        finally {
            this.safeCloseClient();
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    protected abstract void waitForStart(Domain var1, ManagementClient var2) throws LifecycleException;

    protected abstract void stopInternal() throws LifecycleException;

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy directly from a Domain Controller");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy directly from a Domain Controller");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy directly from a Domain Controller");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy directly from a Domain Controller");
    }

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    private void safeCloseClient() {
        try {
            this.managementClient.close();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Caught exception closing ModelControllerClient", e);
        }
    }

    private Container createServerContainer(ContainerRegistry registry, final Domain.Server server, final int operationTimeout) {
        ContainerDef def = new ContainerDefImpl("arquillian").container(server.getContainerName()).setMode("custom");
        return registry.create(def, new ServiceLoader(){

            public <X> X onlyOne(Class<X> serviceClass, Class<? extends X> defaultServiceClass) {
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass, defaultServiceClass);
            }

            public <X> X onlyOne(Class<X> serviceClass) {
                if (serviceClass == DeployableContainer.class) {
                    return serviceClass.cast(((Injector)CommonDomainDeployableContainer.this.injectorInst.get()).inject((Object)new ServerContainer(CommonDomainDeployableContainer.this.managementClient, server, operationTimeout)));
                }
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass);
            }

            public <X> Collection<X> all(Class<X> serviceClass) {
                return ((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).all(serviceClass);
            }
        });
    }

    private Container createServerGroupContainer(ContainerRegistry registry, final ArchiveDeployer archiveDeployer, final Domain domain, final Domain.ServerGroup serverGroup, final int operationTimeout) {
        ContainerDef def = new ContainerDefImpl("arquillian").container(serverGroup.getContainerName()).setMode("suite");
        return registry.create(def, new ServiceLoader(){

            public <X> X onlyOne(Class<X> serviceClass, Class<? extends X> defaultServiceClass) {
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass, defaultServiceClass);
            }

            public <X> X onlyOne(Class<X> serviceClass) {
                if (serviceClass == DeployableContainer.class) {
                    return serviceClass.cast(((Injector)CommonDomainDeployableContainer.this.injectorInst.get()).inject((Object)new ServerGroupContainer(CommonDomainDeployableContainer.this.managementClient, archiveDeployer, domain, serverGroup, operationTimeout)));
                }
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass);
            }

            public <X> Collection<X> all(Class<X> serviceClass) {
                return ((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).all(serviceClass);
            }
        });
    }

    private void updateDomainMembersState(Container.State newState) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInstance.get();
        Domain domain = (Domain)this.domainInst.get();
        for (Domain.Server server : domain.getServers()) {
            registry.getContainer(server.getContainerName()).setState(newState);
        }
        for (Domain.ServerGroup group : domain.getServerGroups()) {
            registry.getContainer(group.getContainerName()).setState(newState);
        }
    }

    private String mapMode(Map<String, String> modeMap, String name) {
        for (Map.Entry<String, String> entry : modeMap.entrySet()) {
            if (!name.matches(entry.getKey())) continue;
            this.log.info("Mapping " + name + " to container mode " + entry.getValue() + " based on expression " + entry.getKey());
            return entry.getValue();
        }
        return null;
    }
}

