/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.context.ContainerContext;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.impl.enricher.resource.OperatesOnDeploymentAwareProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;

public abstract class AbstractTargetsContainerProvider
extends OperatesOnDeploymentAwareProvider {
    @Inject
    private Instance<ContainerContext> containerContext;
    @Inject
    private Instance<ContainerRegistry> containerRegistryInstance;

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        TargetsContainer targetsContainer = this.find(qualifiers);
        if (targetsContainer != null) {
            return this.lookupInContainerContext(targetsContainer, resource, qualifiers);
        }
        return super.lookup(resource, qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookupInContainerContext(TargetsContainer targetsContainer, ArquillianResource resource, Annotation ... qualifiers) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInstance.get();
        ContainerContext context = (ContainerContext)this.containerContext.get();
        boolean contextActivated = false;
        try {
            String name = targetsContainer.value();
            Container container = registry.getContainer(name);
            if (container == null) {
                throw new IllegalArgumentException(String.format("No container named %s found in the registry.", name));
            }
            context.activate((Object)name);
            contextActivated = true;
            Object object = this.doLookup(resource, qualifiers);
            return object;
        }
        finally {
            if (contextActivated) {
                context.deactivate();
            }
        }
    }

    protected TargetsContainer find(Annotation ... annotations) {
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (!(a instanceof TargetsContainer)) continue;
                return (TargetsContainer)TargetsContainer.class.cast(a);
            }
        }
        return null;
    }
}

