/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.as.controller.client.helpers.domain.DeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentSetBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArchiveDeployer {
    private static final Logger log = Logger.getLogger(ArchiveDeployer.class);
    private final DomainDeploymentManager deploymentManager;

    public ArchiveDeployer(DomainDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public String deploy(Archive<?> archive, String target) throws DeploymentException {
        return this.deploy(archive, Collections.singleton(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deploy(Archive<?> archive, Set<String> serverGroups) throws DeploymentException {
        String string;
        block12: {
            if (serverGroups.isEmpty()) {
                throw new DeploymentException("No target server groups to deploy to.");
            }
            InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            try {
                InitialDeploymentSetBuilder builder = this.deploymentManager.newDeploymentPlan().withRollbackAcrossGroups();
                DeployDeploymentPlanBuilder deployBuilder = builder.add(archive.getName(), input).andDeploy();
                ServerGroupDeploymentPlanBuilder serverGroupBuilder = null;
                for (String target : serverGroups) {
                    serverGroupBuilder = serverGroupBuilder == null ? deployBuilder.toServerGroup(target) : serverGroupBuilder.toServerGroup(target);
                }
                DeploymentPlan plan = serverGroupBuilder.build();
                DeploymentAction deployAction = (DeploymentAction)plan.getDeploymentActions().get(plan.getDeploymentActions().size() - 1);
                string = this.executeDeploymentPlan(plan, deployAction);
                if (input == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not deploy to container", (Throwable)e);
                }
            }
            try {
                input.close();
            }
            catch (IOException e) {
                log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
            }
        }
        return string;
    }

    public void undeploy(String runtimeName, String target) throws DeploymentException {
        this.undeploy(runtimeName, Collections.singleton(target));
    }

    public void undeploy(String runtimeName, Set<String> serverGroups) throws DeploymentException {
        if (serverGroups.isEmpty()) {
            throw new DeploymentException("No target server groups to deploy to.");
        }
        try {
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            UndeployDeploymentPlanBuilder undeployBuilder = builder.undeploy(runtimeName);
            ServerGroupDeploymentPlanBuilder serverGroupBuilder = null;
            for (String target : serverGroups) {
                serverGroupBuilder = serverGroupBuilder == null ? undeployBuilder.toServerGroup(target) : serverGroupBuilder.toServerGroup(target);
            }
            DeploymentPlan plan = serverGroupBuilder.build();
            Future future = this.deploymentManager.execute(plan);
            future.get();
        }
        catch (Exception ex) {
            log.warn((Object)("Cannot undeploy: " + runtimeName + ":" + ex.getMessage()));
        }
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Future future = this.deploymentManager.execute(plan);
        DeploymentPlanResult planResult = (DeploymentPlanResult)future.get();
        Map actionResults = planResult.getServerGroupResults();
        for (Map.Entry result : actionResults.entrySet()) {
            for (Map.Entry planServerResult : ((ServerGroupDeploymentPlanResult)result.getValue()).getServerResults().entrySet()) {
                Exception deploymentException;
                ServerUpdateResult actionResult = (ServerUpdateResult)((ServerDeploymentPlanResult)planServerResult.getValue()).getDeploymentActionResults().get(deployAction.getId());
                if (actionResult == null || (deploymentException = (Exception)actionResult.getFailureResult()) == null) continue;
                throw deploymentException;
            }
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

