/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.util.Set;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.domain.ArchiveDeployer;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.EmptyConfiguration;
import org.jboss.as.arquillian.container.domain.LazyHttpContext;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.arquillian.domain.api.DomainManager;

public class ServerGroupContainer
implements DeployableContainer<EmptyConfiguration> {
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<ModelControllerClient> clientInst;
    @Inject
    private Instance<ContainerRegistry> containerRegistryInst;
    private ManagementClient client;
    private ArchiveDeployer deployer;
    private Domain.ServerGroup serverGroup;
    private Domain domain;
    private final DomainManager domainManager;

    public ServerGroupContainer(ManagementClient client, ArchiveDeployer deployer, Domain domain, Domain.ServerGroup serverGroup, DomainManager domainManager) {
        this.client = client;
        this.deployer = deployer;
        this.domain = domain;
        this.serverGroup = serverGroup;
        this.domainManager = domainManager;
    }

    public Class<EmptyConfiguration> getConfigurationClass() {
        return EmptyConfiguration.class;
    }

    public void setup(EmptyConfiguration configuration) {
        this.archiveDeployerInst.set((Object)this.deployer);
        this.clientInst.set((Object)this.client.getControllerClient());
    }

    public void start() throws LifecycleException {
        if (this.domainManager.isDomainStarted()) {
            this.domainManager.startServers(this.serverGroup.getName());
        }
        this.updateGroupMembersContainerState(Container.State.STARTED);
    }

    public void stop() throws LifecycleException {
        if (this.domainManager.isDomainStarted()) {
            this.domainManager.stopServers(this.serverGroup.getName());
        }
        this.updateGroupMembersContainerState(Container.State.STOPPED);
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String uniqueName = this.deployer.deploy(archive, this.serverGroup.getName());
        ProtocolMetaData metaData = new ProtocolMetaData();
        for (Domain.Server server : this.domain.getServersInGroup(this.serverGroup)) {
            metaData.addContext((Object)new LazyHttpContext(server, uniqueName, this.client));
        }
        return metaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.deployer.undeploy(archive.getName(), this.serverGroup.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    private void updateGroupMembersContainerState(Container.State newState) {
        Set<Domain.Server> servers = this.domain.getServersInGroup(this.serverGroup);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInst.get();
        for (Domain.Server server : servers) {
            registry.getContainer(server.getContainerName()).setState(newState);
        }
    }
}

