/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.arquillian.domain.api.DomainManager;
import org.wildfly.arquillian.domain.api.ServerDescription;

public abstract class AbstractDomainManager
implements DomainManager {
    private final String containerName;
    private final boolean lifecycleControlAllowed;

    protected AbstractDomainManager(String containerName, boolean lifecycleControlAllowed) {
        this.containerName = containerName;
        this.lifecycleControlAllowed = lifecycleControlAllowed;
    }

    @Override
    public Set<ServerDescription> getServers() {
        this.checkState(false);
        LinkedHashSet<1> servers = new LinkedHashSet<1>();
        ModelNode op = Operations.createReadResourceOperation((ModelNode)Operations.createAddress((String[])new String[]{"host", "*", "server-config"}));
        ModelNode results = this.runtimeExecuteForSuccess(op);
        for (ModelNode result : results.asList()) {
            ModelNode serverConfig = Operations.readResult((ModelNode)result);
            final String name = serverConfig.get("name").asString();
            final String groupName = serverConfig.get("group").asString();
            final String hostName = ((ModelNode)Operations.getOperationAddress((ModelNode)result).asList().get(0)).get("host").asString();
            servers.add(new ServerDescription(){

                @Override
                public String getHostName() {
                    return hostName;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getGroupName() {
                    return groupName;
                }
            });
        }
        return Collections.unmodifiableSet(servers);
    }

    @Override
    public Set<ServerDescription> getServers(final String hostName) {
        this.checkState(false);
        LinkedHashSet<2> servers = new LinkedHashSet<2>();
        ModelNode op = Operations.createReadResourceOperation((ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config"}));
        ModelNode results = this.runtimeExecuteForSuccess(op);
        for (ModelNode result : results.asList()) {
            ModelNode serverConfig = Operations.readResult((ModelNode)result);
            final String name = serverConfig.get("name").asString();
            final String groupName = serverConfig.get("group").asString();
            servers.add(new ServerDescription(){

                @Override
                public String getHostName() {
                    return hostName;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public String getGroupName() {
                    return groupName;
                }
            });
        }
        return Collections.unmodifiableSet(servers);
    }

    @Override
    public Set<String> getServerGroups() {
        this.checkState(false);
        LinkedHashSet<String> serverGroups = new LinkedHashSet<String>();
        ModelNode op = Operations.createOperation((String)"read-children-names");
        op.get("child-type").set("server-group");
        ModelNode result = this.runtimeExecuteForSuccess(op);
        for (ModelNode serverGroup : result.asList()) {
            serverGroups.add(serverGroup.asString());
        }
        return Collections.unmodifiableSet(serverGroups);
    }

    @Override
    public void startServer(String hostName, String serverName) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"start", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void stopServer(String hostName, String serverName) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"stop", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public boolean isServerStarted(String hostName, String serverName) {
        this.checkState(true);
        ModelNode op = Operations.createReadAttributeOperation((ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}), (String)"status");
        try {
            ModelNode result = this.getModelControllerClient().execute(op);
            if (Operations.isSuccessfulOutcome((ModelNode)result)) {
                return "STARTED".equals(Operations.readResult((ModelNode)result).asString());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void restartServer(String hostName, String serverName) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"restart", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void resumeServer(String hostName, String serverName) {
        this.checkState(true);
        this.runtimeExecuteForSuccess(Operations.createOperation((String)"resume", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName})));
    }

    @Override
    public void suspendServer(String hostName, String serverName, int timeout) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"suspend", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}));
        op.get("timeout").set(timeout);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public String getServerGroupName(String hostName, String serverName) {
        this.checkState(false);
        ModelNode result = this.runtimeExecuteForSuccess(Operations.createReadAttributeOperation((ModelNode)Operations.createAddress((String[])new String[]{"host", hostName, "server-config", serverName}), (String)"group"));
        return result.asString();
    }

    @Override
    public void reloadServers(String name) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"reload-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void restartServers(String name) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"restart-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void resumeServers(String name) {
        this.checkState(true);
        this.runtimeExecuteForSuccess(Operations.createOperation((String)"resume-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name})));
    }

    @Override
    public void startServers(String name) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"start-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void stopServers(String name) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"stop-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name}));
        op.get("blocking").set(true);
        this.runtimeExecuteForSuccess(op);
    }

    @Override
    public void suspendServers(String name, int timeout) {
        this.checkState(true);
        ModelNode op = Operations.createOperation((String)"suspend-servers", (ModelNode)Operations.createAddress((String[])new String[]{"server-group", name}));
        op.get("timeout").set(timeout);
        this.runtimeExecuteForSuccess(op);
    }

    protected abstract ModelControllerClient getModelControllerClient();

    private void checkState(boolean lifecycleControlRequired) {
        if (!this.isDomainStarted()) {
            throw new IllegalStateException("Container " + this.containerName + " has not been started.");
        }
        if (!lifecycleControlRequired && this.lifecycleControlAllowed) {
            throw new IllegalStateException("The lifecycle of container " + this.containerName + " is controlled by Arquillian. Cannot execute lifecycle operations.");
        }
    }

    private ModelNode runtimeExecuteForSuccess(ModelNode op) {
        try {
            return this.executeForSuccess(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode executeForSuccess(ModelNode op) throws IOException {
        ModelControllerClient client = Objects.requireNonNull(this.getModelControllerClient(), "The client cannot be null");
        ModelNode result = client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(Operations.getFailureDescription((ModelNode)result).asString());
        }
        return Operations.readResult((ModelNode)result);
    }
}

