/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class CommonDomainContainerConfiguration
implements ContainerConfiguration {
    private String managementAddress = "127.0.0.1";
    private int managementPort = 9990 + Integer.decode(System.getProperty("jboss.socket.binding.port-offset", "0"));
    private String username;
    private String password;
    private String authenticationConfig;
    private Map<String, String> containerNameMap;
    private Map<String, String> containerModeMap;
    private int serverGroupOperationTimeoutInSeconds = 120;
    private int serverOperationTimeoutInSeconds = 120;

    public InetAddress getManagementAddress() {
        return this.getInetAddress(this.managementAddress);
    }

    String getManagementHostName() {
        return this.managementAddress;
    }

    public void setManagementAddress(String host) {
        this.managementAddress = host;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }

    private InetAddress getInetAddress(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: " + name);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, String> getContainerNameMap() {
        if (this.containerNameMap == null) {
            return new HashMap<String, String>();
        }
        return this.containerNameMap;
    }

    public void setContainerNameMap(String containerNameMap) {
        this.containerNameMap = this.convertToMap(containerNameMap);
    }

    public Map<String, String> getContainerModeMap() {
        if (this.containerModeMap == null) {
            return new HashMap<String, String>();
        }
        return this.containerModeMap;
    }

    public void setContainerModeMap(String containerModeString) {
        this.containerModeMap = this.convertToMap(containerModeString);
    }

    public void setServerGroupOperationTimeoutInSeconds(int serverGroupStartupTimeoutInSeconds) {
        this.serverGroupOperationTimeoutInSeconds = serverGroupStartupTimeoutInSeconds;
    }

    public int getServerGroupOperationTimeoutInSeconds() {
        return this.serverGroupOperationTimeoutInSeconds;
    }

    public void setServerOperationTimeoutInSeconds(int serverStartupTimeoutInSeconds) {
        this.serverOperationTimeoutInSeconds = serverStartupTimeoutInSeconds;
    }

    public int getServerOperationTimeoutInSeconds() {
        return this.serverOperationTimeoutInSeconds;
    }

    public String getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void setAuthenticationConfig(String authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public void validate() throws ConfigurationException {
        if (this.username != null && this.password == null) {
            throw new ConfigurationException("username has been set, but no password given");
        }
    }

    private Map<String, String> convertToMap(String data) {
        String[] values;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String value : values = data.split(",")) {
            String[] content = value.split("=");
            if (content.length != 2) {
                throw new IllegalArgumentException("Could not parse map data from '" + data + "'. Missing value or key in '" + value + "'");
            }
            map.put(this.clean(content[0]), this.clean(content[1]));
        }
        return map;
    }

    private String clean(String data) {
        return data.replaceAll("\\r\\n|\\r|\\n", " ").trim();
    }
}

