/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.domain.ContainerDomainManager;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.arquillian.domain.api.DomainManager;

public class ManagementClient {
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String UNDERTOW = "undertow";
    private static final String PROTOCOL_HTTP = "http";
    private static final String NAME = "name";
    private static final String SERVLET = "servlet";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    private static final int ROOT_RECURSIVE_DEPTH = 3;
    private final DomainClient client;
    private final DomainClient userClient;
    private final Map<String, URI> subsystemURICache;
    private final DomainManager domainManager;
    private ModelNode rootNode = null;

    protected ManagementClient(ModelControllerClient client, DomainManager domainManager) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be specified");
        }
        this.client = client instanceof DomainClient ? (DomainClient)client : DomainClient.Factory.create((ModelControllerClient)client);
        this.subsystemURICache = new HashMap<String, URI>();
        this.userClient = DomainClient.Factory.create((ModelControllerClient)new NonClosingDomainClient(client));
        this.domainManager = domainManager;
    }

    public ManagementClient(ModelControllerClient client, String mgmtAddress, int managementPort) {
        this(client, new ContainerDomainManager("UNKNOWN", false, client, client != null));
    }

    public DomainClient getControllerClient() {
        return this.userClient;
    }

    public Domain createDomain(Map<String, String> containerNameMap) {
        this.lazyLoadRootNode();
        Domain domain = new Domain();
        for (String hostNodeName : this.rootNode.get("host").keys()) {
            ModelNode serverConfigNode = this.rootNode.get("host").get(hostNodeName).get("server-config");
            if (!serverConfigNode.isDefined()) continue;
            for (String serverConfigName : serverConfigNode.keys()) {
                ModelNode serverConfig = this.rootNode.get("host").get(hostNodeName).get("server-config").get(serverConfigName);
                Domain.Server server = new Domain.Server(serverConfig.get(NAME).asString(), hostNodeName, serverConfig.get("group").asString(), serverConfig.get("auto-start").asBoolean());
                if (containerNameMap.containsKey(server.getUniqueName())) {
                    server.setContainerName(containerNameMap.get(server.getUniqueName()));
                }
                domain.addServer(server);
            }
        }
        for (String serverGroupName : this.rootNode.get("server-group").keys()) {
            Domain.ServerGroup group = new Domain.ServerGroup(serverGroupName);
            if (containerNameMap.containsKey(group.getName())) {
                group.setContainerName(containerNameMap.get(group.getName()));
            }
            domain.addServerGroup(group);
        }
        return domain;
    }

    public String getServerState(Domain.Server server) {
        this.lazyLoadRootNode();
        ModelNode hostNode = this.rootNode.get("host").get(server.getHost());
        if (!hostNode.isDefined()) {
            throw new IllegalArgumentException("Host not found on domain " + server.getHost());
        }
        ModelNode serverConfig = hostNode.get("server-config").get(server.getName());
        if (!serverConfig.isDefined()) {
            throw new IllegalArgumentException("Server " + server + " not found on host " + server.getHost());
        }
        return serverConfig.get("status").asString();
    }

    public HTTPContext getHTTPDeploymentMetaData(Domain.Server server, String uniqueDeploymentName) {
        URI webURI = this.getProtocolURI(server, PROTOCOL_HTTP);
        HTTPContext context = new HTTPContext(webURI.getHost(), webURI.getPort());
        try {
            ModelNode deploymentNode = this.readResource(this.createHostServerDeploymentAddress(server.getHost(), server.getName(), uniqueDeploymentName));
            if (this.isWebArchive(uniqueDeploymentName)) {
                this.extractWebArchiveContexts(context, deploymentNode);
            } else if (this.isEnterpriseArchive(uniqueDeploymentName)) {
                this.extractEnterpriseArchiveContexts(context, deploymentNode);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract deployment information for server: " + server + " on deployment: " + uniqueDeploymentName, e);
        }
        return context;
    }

    public void startServerGroup(String groupName) {
        this.domainManager.startServers(groupName);
    }

    public void stopServerGroup(String groupName) {
        this.domainManager.stopServers(groupName);
    }

    public void startServer(Domain.Server server) {
        this.domainManager.startServer(server.getHost(), server.getName());
    }

    public void stopServer(Domain.Server server) {
        this.domainManager.stopServer(server.getHost(), server.getName());
    }

    public boolean isServerStarted(Domain.Server server) {
        return this.domainManager.isServerStarted(server.getHost(), server.getName());
    }

    public boolean isDomainInRunningState() {
        HashMap<ServerIdentity, ServerStatus> servers = new HashMap<ServerIdentity, ServerStatus>();
        try {
            Map statuses = this.client.getServerStatuses();
            for (ServerIdentity id : statuses.keySet()) {
                ServerStatus status = (ServerStatus)statuses.get(id);
                switch (status) {
                    case DISABLED: 
                    case STARTED: {
                        servers.put(id, status);
                    }
                }
            }
            return statuses.size() == servers.size();
        }
        catch (Exception e) {
            Logger.getLogger(ManagementClient.class).debug((Object)"Interrupted determining if domain is running", (Throwable)e);
            return false;
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close connection", e);
        }
    }

    private URI getProtocolURI(Domain.Server server, String subsystem) {
        String cacheKey = server + subsystem;
        URI subsystemURI = this.subsystemURICache.get(cacheKey);
        if (subsystemURI != null) {
            return subsystemURI;
        }
        subsystemURI = this.extractProtocolURI(server, subsystem);
        this.subsystemURICache.put(cacheKey, subsystemURI);
        return subsystemURI;
    }

    private URI extractProtocolURI(Domain.Server server, String protocol) {
        try {
            ModelNode node = this.readResource(this.createHostServerSocketBindingsAddress(server.getHost(), server.getName(), this.getSocketBindingGroup(server.getGroup())));
            ModelNode socketBinding = node.get("socket-binding").get(protocol);
            return URI.create(protocol + "://" + socketBinding.get("bound-address").asString() + ":" + socketBinding.get("bound-port"));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract address information from server: " + server + " for protocol " + protocol + ". Is the server running?", e);
        }
    }

    private void readRootNode() throws Exception {
        this.rootNode = this.readResource(new ModelNode(), 3);
    }

    private String getSocketBindingGroup(String serverGroup) {
        this.lazyLoadRootNode();
        return this.rootNode.get("server-group").get(serverGroup).get("socket-binding-group").asString();
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private ModelNode createHostServerDeploymentAddress(String host, String server, String deploymentName) {
        return new ModelNode().add("host", host).add("server", server).add("deployment", deploymentName);
    }

    private ModelNode createHostServerSocketBindingsAddress(String host, String server, String socketBindingGroup) {
        return new ModelNode().add("host", host).add("server", server).add("socket-binding-group", socketBindingGroup);
    }

    private void extractEnterpriseArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        if (deploymentNode.hasDefined(SUBDEPLOYMENT)) {
            for (ModelNode subdeployment : deploymentNode.get(SUBDEPLOYMENT).asList()) {
                String deploymentName = (String)subdeployment.keys().iterator().next();
                if (!this.isWebArchive(deploymentName)) continue;
                this.extractWebArchiveContexts(context, deploymentName, subdeployment.get(deploymentName));
            }
        }
    }

    private void extractWebArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        this.extractWebArchiveContexts(context, deploymentNode.get(NAME).asString(), deploymentNode);
    }

    private void extractWebArchiveContexts(HTTPContext context, String deploymentName, ModelNode deploymentNode) {
        ModelNode webSubSystem;
        ModelNode subsystem;
        if (deploymentNode.hasDefined("subsystem") && (subsystem = deploymentNode.get("subsystem")).hasDefined(UNDERTOW) && (webSubSystem = subsystem.get(UNDERTOW)).isDefined() && webSubSystem.hasDefined("context-root")) {
            String contextName = webSubSystem.get("context-root").asString();
            if (webSubSystem.hasDefined(SERVLET)) {
                for (ModelNode servletNode : webSubSystem.get(SERVLET).asList()) {
                    for (String servletName : servletNode.keys()) {
                        context.add(new Servlet(servletName, this.toContextName(contextName)));
                    }
                }
            }
            context.add(new Servlet("default", this.toContextName(contextName)));
        }
    }

    private String toContextName(String deploymentName) {
        String correctedName = deploymentName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private void lazyLoadRootNode() {
        try {
            if (this.rootNode == null) {
                this.readRootNode();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode readResource(ModelNode address) throws Exception {
        return this.readResource(address, null);
    }

    private ModelNode readResource(ModelNode address, Integer recursiveDepth) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        if (recursiveDepth == null) {
            operation.get("recursive").set(true);
        } else {
            operation.get("recursive-depth").set(recursiveDepth.intValue());
        }
        operation.get("include-runtime").set(true);
        operation.get("proxies").set(true);
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    private static class NonClosingDomainClient
    extends DelegatingModelControllerClient {
        NonClosingDomainClient(ModelControllerClient delegate) {
            super(delegate);
        }

        public void close() throws IOException {
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        UnSuccessfulOperationException(String message) {
            super(message);
        }
    }
}

