/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.config.descriptor.impl.ContainerDefImpl;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.SetupContainer;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.as.arquillian.container.domain.ArchiveDeployer;
import org.jboss.as.arquillian.container.domain.Authentication;
import org.jboss.as.arquillian.container.domain.CommonDomainContainerConfiguration;
import org.jboss.as.arquillian.container.domain.ContainerDomainManager;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.LazyHttpContext;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.arquillian.container.domain.ServerContainer;
import org.jboss.as.arquillian.container.domain.ServerGroupContainer;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.arquillian.domain.ServerGroupArchive;
import org.wildfly.arquillian.domain.api.DomainManager;

public abstract class CommonDomainDeployableContainer<T extends CommonDomainContainerConfiguration>
implements DeployableContainer<T> {
    @Inject
    private Instance<ContainerRegistry> containerRegistryInstance;
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    private Instance<Injector> injectorInst;
    @Inject
    private Instance<Container> containerInst;
    @Inject
    private Event<SetupContainer> setupEvent;
    private final Logger log = Logger.getLogger(CommonDomainDeployableContainer.class.getName());
    private T containerConfig;
    private ManagementClient managementClient;
    private volatile ContainerDomainManager domainManager;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<ManagementClient> managementClientInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<Domain> domainInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(T config) {
        this.containerConfig = config;
        DomainClient domainClient = DomainClient.Factory.create((ModelControllerClient)new DelegatingModelControllerClient((DelegatingModelControllerClient.DelegateProvider)DomainDelegateProvider.INSTANCE));
        this.domainManager = new ContainerDomainManager(this.getContainerName(), this.isControllable(), (ModelControllerClient)domainClient);
        this.managementClient = new ManagementClient((ModelControllerClient)domainClient, this.domainManager);
        this.managementClientInst.set((Object)this.managementClient);
        ArchiveDeployer archiveDeployer = new ArchiveDeployer(this.managementClient);
        this.archiveDeployerInst.set((Object)archiveDeployer);
    }

    public void start() throws LifecycleException {
        String mode;
        Container serverContainer;
        String authenticationConfig;
        ModelControllerClientConfiguration.Builder clientConfigBuilder = new ModelControllerClientConfiguration.Builder().setHostName(((CommonDomainContainerConfiguration)this.containerConfig).getManagementHostName()).setPort(((CommonDomainContainerConfiguration)this.containerConfig).getManagementPort());
        if (((CommonDomainContainerConfiguration)this.containerConfig).getUsername() != null) {
            Authentication.username = ((CommonDomainContainerConfiguration)this.containerConfig).getUsername();
            Authentication.password = ((CommonDomainContainerConfiguration)this.containerConfig).getPassword();
            clientConfigBuilder.setHandler(Authentication.getCallbackHandler());
        }
        if ((authenticationConfig = ((CommonDomainContainerConfiguration)this.containerConfig).getAuthenticationConfig()) != null) {
            clientConfigBuilder.setAuthenticationConfigUri(URI.create(authenticationConfig));
        }
        DomainDelegateProvider.INSTANCE.setDelegate(ModelControllerClient.Factory.create((ModelControllerClientConfiguration)clientConfigBuilder.build()));
        try {
            this.startInternal();
        }
        catch (LifecycleException e) {
            this.safeCloseClient();
            throw e;
        }
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInstance.get();
        Map<String, String> containerNameMap = ((CommonDomainContainerConfiguration)this.containerConfig).getContainerNameMap();
        Map<String, String> modeMap = ((CommonDomainContainerConfiguration)this.containerConfig).getContainerModeMap();
        Domain domain = this.managementClient.createDomain(containerNameMap);
        this.domainInst.set((Object)domain);
        for (Domain.ServerGroup serverGroup : domain.getServerGroups()) {
            serverContainer = this.createServerGroupContainer(registry, (ArchiveDeployer)this.archiveDeployerInst.get(), domain, serverGroup);
            mode = this.mapMode(modeMap, serverContainer.getName());
            if (mode != null) {
                serverContainer.getContainerConfiguration().setMode(mode);
            }
            this.setupEvent.fire((Object)new SetupContainer(serverContainer));
            serverContainer.setState(Container.State.STARTED);
        }
        for (Domain.Server server : domain.getServers()) {
            serverContainer = this.createServerContainer(registry, server);
            mode = this.mapMode(modeMap, serverContainer.getName());
            if (mode != null) {
                serverContainer.getContainerConfiguration().setMode(mode);
            }
            String serverStatus = this.managementClient.getServerState(server);
            this.setupEvent.fire((Object)new SetupContainer(serverContainer));
            if (serverStatus.equals("STARTED")) {
                serverContainer.setState(Container.State.STARTED);
                continue;
            }
            serverContainer.setState(Container.State.STOPPED);
        }
        this.domainManager.setContainerStarted(true);
    }

    public final void stop() throws LifecycleException {
        this.domainManager.setContainerStarted(false);
        try {
            this.updateDomainMembersState(Container.State.STOPPED);
            this.stopInternal();
        }
        finally {
            this.safeCloseClient();
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    protected abstract void stopInternal() throws LifecycleException;

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        Set<String> serverGroups = CommonDomainDeployableContainer.getServerGroups(archive);
        if (!serverGroups.isEmpty()) {
            ProtocolMetaData metaData = new ProtocolMetaData();
            ArchiveDeployer deployer = (ArchiveDeployer)this.archiveDeployerInst.get();
            String uniqueName = deployer.deploy(archive, serverGroups);
            Domain domain = (Domain)this.domainInst.get();
            for (String serverGroupName : serverGroups) {
                for (Domain.Server server : domain.getServersInGroup(serverGroupName)) {
                    metaData.addContext((Object)new LazyHttpContext(server, uniqueName, this.managementClient));
                }
            }
            return metaData;
        }
        throw new DeploymentException("Could not determine the server-group to deploy the archive to.");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        Set<String> serverGroups = CommonDomainDeployableContainer.getServerGroups(archive);
        if (serverGroups.isEmpty()) {
            throw new DeploymentException("Could not determine the server-group for the undeploy.");
        }
        ArchiveDeployer deployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        deployer.undeploy(archive.getName(), serverGroups);
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy directly from a Domain Controller");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy directly from a Domain Controller");
    }

    public DomainManager getDomainManager() {
        return this.domainManager;
    }

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    private void safeCloseClient() {
        try {
            this.managementClient.close();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Caught exception closing ModelControllerClient", e);
        }
        finally {
            DomainDelegateProvider.INSTANCE.setDelegate(null);
        }
    }

    private Container createServerContainer(ContainerRegistry registry, final Domain.Server server) {
        ContainerDef def = new ContainerDefImpl("arquillian").container(server.getContainerName()).setMode(this.getContainerMode());
        return registry.create(def, new ServiceLoader(){

            public <X> X onlyOne(Class<X> serviceClass, Class<? extends X> defaultServiceClass) {
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass, defaultServiceClass);
            }

            public <X> X onlyOne(Class<X> serviceClass) {
                if (serviceClass == DeployableContainer.class) {
                    return serviceClass.cast(((Injector)CommonDomainDeployableContainer.this.injectorInst.get()).inject((Object)new ServerContainer(CommonDomainDeployableContainer.this.domainManager, server)));
                }
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass);
            }

            public <X> Collection<X> all(Class<X> serviceClass) {
                return ((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).all(serviceClass);
            }
        });
    }

    private Container createServerGroupContainer(ContainerRegistry registry, final ArchiveDeployer archiveDeployer, final Domain domain, final Domain.ServerGroup serverGroup) {
        ContainerDef def = new ContainerDefImpl("arquillian").container(serverGroup.getContainerName()).setMode(this.getContainerMode());
        return registry.create(def, new ServiceLoader(){

            public <X> X onlyOne(Class<X> serviceClass, Class<? extends X> defaultServiceClass) {
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass, defaultServiceClass);
            }

            public <X> X onlyOne(Class<X> serviceClass) {
                if (serviceClass == DeployableContainer.class) {
                    return serviceClass.cast(((Injector)CommonDomainDeployableContainer.this.injectorInst.get()).inject((Object)new ServerGroupContainer(CommonDomainDeployableContainer.this.managementClient, archiveDeployer, domain, serverGroup, CommonDomainDeployableContainer.this.domainManager)));
                }
                return (X)((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).onlyOne(serviceClass);
            }

            public <X> Collection<X> all(Class<X> serviceClass) {
                return ((ServiceLoader)CommonDomainDeployableContainer.this.serviceLoaderInstance.get()).all(serviceClass);
            }
        });
    }

    private void updateDomainMembersState(Container.State newState) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInstance.get();
        Domain domain = (Domain)this.domainInst.get();
        for (Domain.Server server : domain.getServers()) {
            registry.getContainer(server.getContainerName()).setState(newState);
        }
        for (Domain.ServerGroup group : domain.getServerGroups()) {
            registry.getContainer(group.getContainerName()).setState(newState);
        }
    }

    private String mapMode(Map<String, String> modeMap, String name) {
        for (Map.Entry<String, String> entry : modeMap.entrySet()) {
            if (!name.matches(entry.getKey())) continue;
            this.log.info("Mapping " + name + " to container mode " + entry.getValue() + " based on expression " + entry.getKey());
            return entry.getValue();
        }
        return null;
    }

    private String getContainerMode() {
        Container container = (Container)this.containerInst.get();
        return container.getContainerConfiguration().getMode();
    }

    private String getContainerName() {
        Container container = (Container)this.containerInst.get();
        return container.getName();
    }

    private boolean isControllable() {
        String mode = this.getContainerMode();
        return "manual".equalsIgnoreCase(mode) || "custom".equalsIgnoreCase(mode);
    }

    private static Set<String> getServerGroups(Archive<?> archive) throws DeploymentException {
        if (archive instanceof ServerGroupArchive) {
            return ((ServerGroupArchive)archive).getServerGroups();
        }
        throw new DeploymentException("Could not determine the server-group to deploy the archive to.");
    }

    private static class DomainDelegateProvider
    implements DelegatingModelControllerClient.DelegateProvider {
        static final DomainDelegateProvider INSTANCE = new DomainDelegateProvider();
        private final AtomicReference<ModelControllerClient> delegate = new AtomicReference();

        private DomainDelegateProvider() {
        }

        void setDelegate(ModelControllerClient client) {
            this.delegate.set(client);
        }

        public ModelControllerClient getDelegate() {
            ModelControllerClient result = this.delegate.get();
            if (result == null) {
                throw new IllegalStateException("The client has been closed. Ensure the container has been started.");
            }
            return result;
        }
    }
}

