/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.EmptyConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.arquillian.domain.api.DomainManager;

public class ServerContainer
implements DeployableContainer<EmptyConfiguration> {
    private final DomainManager domainManager;
    private final Domain.Server server;

    public ServerContainer(DomainManager domainManager, Domain.Server server) {
        this.domainManager = domainManager;
        this.server = server;
    }

    public Class<EmptyConfiguration> getConfigurationClass() {
        return EmptyConfiguration.class;
    }

    public void setup(EmptyConfiguration configuration) {
    }

    public void start() throws LifecycleException {
        if (this.domainManager.isDomainStarted()) {
            this.domainManager.startServer(this.server.getHost(), this.server.getName());
        }
    }

    public void stop() throws LifecycleException {
        if (this.domainManager.isDomainStarted()) {
            this.domainManager.stopServer(this.server.getHost(), this.server.getName());
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy to a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy from a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not deploy to a single server in the domain, target server-group " + this.server.getGroup());
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Can not undeploy from a single server in the domain, target server-group " + this.server.getGroup());
    }
}

