/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain.container.controller.command;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.wildfly.arquillian.domain.api.DomainContainerController;
import org.wildfly.arquillian.domain.container.controller.command.GetServerStatusCommand;
import org.wildfly.arquillian.domain.container.controller.command.ServerGroupLifecycleCommand;
import org.wildfly.arquillian.domain.container.controller.command.ServerLifecycleCommand;

public class DomainContainerCommandObserver {
    @Inject
    private Instance<DomainContainerController> controllerInst;

    public void serverGroupLifecycle(@Observes ServerGroupLifecycleCommand event) {
        switch (event.getLifecycle()) {
            case RELOAD: {
                ((DomainContainerController)this.controllerInst.get()).reloadServers(event.getContainerQualifier(), event.getServerGroupName());
                break;
            }
            case RESTART: {
                ((DomainContainerController)this.controllerInst.get()).restartServers(event.getContainerQualifier(), event.getServerGroupName());
                break;
            }
            case RESUME: {
                ((DomainContainerController)this.controllerInst.get()).resumeServers(event.getContainerQualifier(), event.getServerGroupName());
                break;
            }
            case START: {
                ((DomainContainerController)this.controllerInst.get()).startServers(event.getContainerQualifier(), event.getServerGroupName());
                break;
            }
            case STOP: {
                ((DomainContainerController)this.controllerInst.get()).stopServers(event.getContainerQualifier(), event.getServerGroupName());
                break;
            }
            case SUSPEND: {
                ((DomainContainerController)this.controllerInst.get()).suspendServers(event.getContainerQualifier(), event.getServerGroupName(), event.getTimeout());
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not determine how to execute the lifecycle " + (Object)((Object)event.getLifecycle()));
            }
        }
        event.setResult(Boolean.TRUE);
    }

    public void serverLifecycle(@Observes ServerLifecycleCommand event) {
        switch (event.getLifecycle()) {
            case RESTART: {
                ((DomainContainerController)this.controllerInst.get()).restartServer(event.getContainerQualifier(), event.getHostName(), event.getServerName());
                break;
            }
            case RESUME: {
                ((DomainContainerController)this.controllerInst.get()).resumeServer(event.getContainerQualifier(), event.getHostName(), event.getServerName());
                break;
            }
            case START: {
                ((DomainContainerController)this.controllerInst.get()).startServer(event.getContainerQualifier(), event.getHostName(), event.getServerName());
                break;
            }
            case STOP: {
                ((DomainContainerController)this.controllerInst.get()).stopServer(event.getContainerQualifier(), event.getHostName(), event.getServerName());
                break;
            }
            case SUSPEND: {
                ((DomainContainerController)this.controllerInst.get()).suspendServer(event.getContainerQualifier(), event.getHostName(), event.getServerName(), event.getTimeout());
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not determine how to execute the lifecycle " + (Object)((Object)event.getLifecycle()));
            }
        }
        event.setResult(Boolean.TRUE);
    }

    public void checkServerStatus(@Observes GetServerStatusCommand event) {
        event.setResult(((DomainContainerController)this.controllerInst.get()).isServerStarted(event.getContainerQualifier(), event.getHostName(), event.getServerName()));
    }
}

