/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.util.List;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.ManagementClient;

public class LazyHttpContext
extends HTTPContext {
    private Domain.Server server;
    private String deploymentName;
    private ManagementClient client;
    private HTTPContext context = null;

    public LazyHttpContext(Domain.Server server, String deploymentName, ManagementClient client) {
        super("localhost", -1);
        this.server = server;
        this.deploymentName = deploymentName;
        this.client = client;
    }

    public String getName() {
        return this.server.getContainerName();
    }

    public String getHost() {
        this.initiateContext();
        return this.context.getHost();
    }

    public int getPort() {
        this.initiateContext();
        return this.context.getPort();
    }

    public HTTPContext add(Servlet servlet) {
        this.initiateContext();
        return this.context.add(servlet);
    }

    public List<Servlet> getServlets() {
        this.initiateContext();
        return this.context.getServlets();
    }

    public Servlet getServletByName(String name) {
        this.initiateContext();
        return this.context.getServletByName(name);
    }

    private void initiateContext() {
        if (this.context == null) {
            this.context = this.client.getHTTPDeploymentMetaData(this.server, this.deploymentName);
        }
    }
}

