/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain.container.controller;

import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.test.impl.client.container.ClientContainerController;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.domain.CommonDomainDeployableContainer;
import org.wildfly.arquillian.domain.api.DomainContainerController;
import org.wildfly.arquillian.domain.api.DomainManager;

public class ClientDomainContainerController
extends ClientContainerController
implements DomainContainerController {
    @Inject
    private Instance<ContainerRegistry> containerRegistry;

    @Override
    public void reloadServers(String containerQualifier, String groupName) {
        this.getDomainController(containerQualifier).reloadServers(groupName);
    }

    @Override
    public void restartServers(String containerQualifier, String groupName) {
        this.getDomainController(containerQualifier).restartServers(groupName);
    }

    @Override
    public void resumeServers(String containerQualifier, String groupName) {
        this.getDomainController(containerQualifier).resumeServers(groupName);
    }

    @Override
    public void startServers(String containerQualifier, String groupName) {
        this.getDomainController(containerQualifier).startServers(groupName);
    }

    @Override
    public void stopServers(String containerQualifier, String groupName) {
        this.getDomainController(containerQualifier).stopServers(groupName);
    }

    @Override
    public void suspendServers(String containerQualifier, String groupName, int timeout) {
        this.getDomainController(containerQualifier).suspendServers(groupName, timeout);
    }

    @Override
    public void startServer(String containerQualifier, String hostName, String serverName) {
        this.getDomainController(containerQualifier).startServer(hostName, serverName);
    }

    @Override
    public void stopServer(String containerQualifier, String hostName, String serverName) {
        this.getDomainController(containerQualifier).stopServer(hostName, serverName);
    }

    @Override
    public boolean isServerStarted(String containerQualifier, String hostName, String serverName) {
        return this.getDomainController(containerQualifier).isServerStarted(hostName, serverName);
    }

    @Override
    public void restartServer(String containerQualifier, String hostName, String serverName) {
        this.getDomainController(containerQualifier).restartServer(hostName, serverName);
    }

    @Override
    public void resumeServer(String containerQualifier, String hostName, String serverName) {
        this.getDomainController(containerQualifier).resumeServer(hostName, serverName);
    }

    @Override
    public void suspendServer(String containerQualifier, String hostName, String serverName, int timeout) {
        this.getDomainController(containerQualifier).suspendServer(hostName, serverName, timeout);
    }

    private DomainManager getDomainController(String containerQualifier) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            throw new IllegalArgumentException("No container registry in context");
        }
        if (!this.containerExists(registry.getContainers(), containerQualifier)) {
            throw new IllegalArgumentException("No container with the specified name exists");
        }
        if (!this.isStarted(containerQualifier)) {
            throw new IllegalArgumentException(String.format("Container %s has not been started.", containerQualifier));
        }
        Container container = registry.getContainer(containerQualifier);
        DeployableContainer deployableContainer = container.getDeployableContainer();
        if (deployableContainer instanceof CommonDomainDeployableContainer) {
            return ((CommonDomainDeployableContainer)deployableContainer).getDomainManager();
        }
        throw new IllegalArgumentException(String.format("The container defined with %s is not a domain controller", containerQualifier));
    }
}

