/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain.container.controller;

import org.jboss.arquillian.container.test.impl.client.container.ContainerContainerController;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.wildfly.arquillian.domain.api.DomainContainerController;
import org.wildfly.arquillian.domain.container.controller.command.GetServerStatusCommand;
import org.wildfly.arquillian.domain.container.controller.command.Lifecycle;
import org.wildfly.arquillian.domain.container.controller.command.ServerGroupLifecycleCommand;
import org.wildfly.arquillian.domain.container.controller.command.ServerLifecycleCommand;

public class InContainerDomainContainerController
extends ContainerContainerController
implements DomainContainerController {
    @Override
    public void reloadServers(String containerQualifier, String groupName) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.RELOAD, groupName));
    }

    @Override
    public void restartServers(String containerQualifier, String groupName) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.RESTART, groupName));
    }

    @Override
    public void resumeServers(String containerQualifier, String groupName) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.RESUME, groupName));
    }

    @Override
    public void startServers(String containerQualifier, String groupName) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.START, groupName));
    }

    @Override
    public void stopServers(String containerQualifier, String groupName) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.STOP, groupName));
    }

    @Override
    public void suspendServers(String containerQualifier, String groupName, int timeout) {
        this.getCommandService().execute((Command)new ServerGroupLifecycleCommand(containerQualifier, Lifecycle.SUSPEND, groupName, timeout));
    }

    @Override
    public void startServer(String containerQualifier, String hostName, String serverName) {
        this.getCommandService().execute((Command)new ServerLifecycleCommand(containerQualifier, Lifecycle.START, hostName, serverName));
    }

    @Override
    public void stopServer(String containerQualifier, String hostName, String serverName) {
        this.getCommandService().execute((Command)new ServerLifecycleCommand(containerQualifier, Lifecycle.STOP, hostName, serverName));
    }

    @Override
    public boolean isServerStarted(String containerQualifier, String hostName, String serverName) {
        return (Boolean)this.getCommandService().execute((Command)new GetServerStatusCommand(containerQualifier, hostName, serverName));
    }

    @Override
    public void restartServer(String containerQualifier, String hostName, String serverName) {
        this.getCommandService().execute((Command)new ServerLifecycleCommand(containerQualifier, Lifecycle.RESTART, hostName, serverName));
    }

    @Override
    public void resumeServer(String containerQualifier, String hostName, String serverName) {
        this.getCommandService().execute((Command)new ServerLifecycleCommand(containerQualifier, Lifecycle.RESUME, hostName, serverName));
    }

    @Override
    public void suspendServer(String containerQualifier, String hostName, String serverName, int timeout) {
        this.getCommandService().execute((Command)new ServerLifecycleCommand(containerQualifier, Lifecycle.SUSPEND, hostName, serverName, timeout));
    }
}

