/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.jboss.as.arquillian.container.domain;

/**
 * Utility methods related to networking.
 *
 * @author Brian Stansberry (c) 2011 Red Hat Inc.
 */
public class NetworkUtils {

    public static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }

    // No instantiation
    private NetworkUtils() {

    }
}
