/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class ArchiveDeployer {
    private static final Logger log = Logger.getLogger(ArchiveDeployer.class);
    private final ServerDeploymentHelper deployer;
    private final ManagementClient client;

    @Deprecated
    public ArchiveDeployer(ModelControllerClient modelControllerClient) {
        this.deployer = new ServerDeploymentHelper(modelControllerClient);
        this.client = null;
    }

    public ArchiveDeployer(ManagementClient client) {
        this.client = client;
        this.deployer = new ServerDeploymentHelper(client.getControllerClient());
    }

    public String deploy(Archive<?> archive) throws DeploymentException {
        return this.deployInternal(archive);
    }

    public String deploy(String name, InputStream input) throws DeploymentException {
        return this.deployInternal(name, input);
    }

    public void undeploy(String runtimeName) {
        try {
            this.deployer.undeploy(runtimeName);
        }
        catch (Exception ex) {
            log.warnf((Throwable)ex, "Cannot undeploy: %s", (Object)runtimeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deployInternal(Archive<?> archive) throws DeploymentException {
        this.checkState();
        InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
        try {
            String string = this.deployInternal(archive.getName(), input);
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
                }
            }
        }
    }

    private String deployInternal(String name, InputStream input) throws DeploymentException {
        this.checkState();
        try {
            return this.deployer.deploy(name, input);
        }
        catch (Exception ex) {
            Throwable rootCause;
            for (rootCause = ex.getCause(); null != rootCause && rootCause.getCause() != null; rootCause = rootCause.getCause()) {
            }
            throw new DeploymentException("Cannot deploy: " + name, rootCause);
        }
    }

    private void checkState() {
        if (this.client != null && this.client.isClosed()) {
            throw new IllegalStateException("The client connection has been closed.");
        }
    }
}

