/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.setup;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class ConfigureLoggingSetupTask
implements ServerSetupTask {
    private final String handlerType;
    private final String handlerName;
    private final Map<String, Set<String>> logLevels;
    private final BlockingDeque<ModelNode> tearDownOps;

    public ConfigureLoggingSetupTask() {
        this(Map.of());
    }

    public ConfigureLoggingSetupTask(String handlerType, String handlerName) {
        this(handlerType, handlerName, Map.of());
    }

    public ConfigureLoggingSetupTask(Map<String, Set<String>> logLevels) {
        this(null, null, logLevels);
    }

    public ConfigureLoggingSetupTask(String handlerType, String handlerName, Map<String, Set<String>> logLevels) {
        this.handlerType = handlerType == null ? "console-handler" : handlerType;
        this.handlerName = handlerName == null ? "CONSOLE" : handlerName;
        this.logLevels = ConfigureLoggingSetupTask.createMap(logLevels);
        this.tearDownOps = new LinkedBlockingDeque<ModelNode>();
    }

    @Override
    public void setup(ManagementClient client, String containerId) throws Exception {
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        ModelNode address = Operations.createAddress((String[])new String[]{"subsystem", "logging", this.handlerType, this.handlerName});
        ModelNode currentValue = this.executeOp(client.getControllerClient(), Operations.createReadAttributeOperation((ModelNode)address, (String)"level"));
        if (currentValue.isDefined()) {
            this.tearDownOps.add(Operations.createWriteAttributeOperation((ModelNode)address, (String)"level", (String)currentValue.asString()));
        }
        builder.addStep(Operations.createUndefineAttributeOperation((ModelNode)address, (String)"level"));
        for (Map.Entry<String, Set<String>> entry : this.logLevels.entrySet()) {
            for (String logger : entry.getValue()) {
                address = logger.isBlank() ? Operations.createAddress((String[])new String[]{"subsystem", "logging", "root-logger", "ROOT"}) : Operations.createAddress((String[])new String[]{"subsystem", "logging", "logger", logger});
                builder.addStep(this.createLoggerOp(client.getControllerClient(), address, entry.getKey()));
            }
        }
        this.executeOp(client.getControllerClient(), builder.build());
    }

    @Override
    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        ModelNode removeOp;
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        while ((removeOp = (ModelNode)this.tearDownOps.pollFirst()) != null) {
            builder.addStep(removeOp);
        }
        this.executeOp(managementClient.getControllerClient(), builder.build());
    }

    private ModelNode createLoggerOp(ModelControllerClient client, ModelNode address, String level) throws IOException {
        ModelNode op = Operations.createReadResourceOperation((ModelNode)address);
        ModelNode result = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            ModelNode loggerConfig = Operations.readResult((ModelNode)result);
            if (loggerConfig.hasDefined("level")) {
                this.tearDownOps.add(Operations.createWriteAttributeOperation((ModelNode)address, (String)"level", (String)loggerConfig.get("level").asString()));
            }
            return Operations.createWriteAttributeOperation((ModelNode)address, (String)"level", (String)level);
        }
        this.tearDownOps.add(Operations.createRemoveOperation((ModelNode)address));
        ModelNode addOp = Operations.createAddOperation((ModelNode)address);
        addOp.get("level").set(level);
        return addOp;
    }

    private ModelNode executeOp(ModelControllerClient client, ModelNode op) throws IOException {
        return this.executeOp(client, Operation.Factory.create((ModelNode)op));
    }

    private ModelNode executeOp(ModelControllerClient client, Operation op) throws IOException {
        ModelNode result = client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(Operations.getFailureDescription((ModelNode)result).asString());
        }
        return Operations.readResult((ModelNode)result);
    }

    private static Map<String, Set<String>> createMap(Map<String, Set<String>> toMerge) {
        HashMap<String, Set<String>> logLevels = new HashMap<String, Set<String>>();
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "all");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "trace");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "debug");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "info");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "warn");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "error");
        ConfigureLoggingSetupTask.addLoggingConfig(logLevels, "off");
        return Map.copyOf(ConfigureLoggingSetupTask.merge(logLevels, toMerge));
    }

    private static void addLoggingConfig(Map<String, Set<String>> map, String level) {
        Set<String> names;
        String value = System.getProperty("wildfly.logging.level." + level);
        if (value != null && !(names = Set.of(value.split(","))).isEmpty()) {
            map.put(level.toUpperCase(Locale.ROOT), names);
        }
    }

    private static Map<String, Set<String>> merge(Map<String, Set<String>> map1, Map<String, Set<String>> map2) {
        HashMap result = new HashMap();
        for (Map.Entry<String, Set<String>> entry : map1.entrySet()) {
            result.put(entry.getKey().toUpperCase(Locale.ROOT), entry.getValue());
        }
        for (Map.Entry<String, Set<String>> entry : map2.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            String key = entry.getKey().toUpperCase(Locale.ROOT);
            if (result.containsKey(key)) {
                result.put(key, Stream.concat(((Set)result.get(key)).stream(), entry.getValue().stream()).collect(Collectors.toSet()));
                continue;
            }
            result.put(key, Set.copyOf((Collection)entry.getValue()));
        }
        return Map.copyOf(result);
    }
}

