/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.ArchiveDeployer;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonManagedDeployableContainer;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.wildfly.plugin.tools.ContainerDescription;
import org.wildfly.plugin.tools.server.ServerManager;
import org.wildfly.plugin.tools.server.StandaloneManager;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    private static final String JBOSS_URL_PKG_PREFIX = "org.jboss.ejb.client.naming";
    private static final String READ_OPERATION_DESCRIPTION_OPERATION = "read-operation-description";
    private T containerConfig;
    @Inject
    @ContainerScoped
    private InstanceProducer<ManagementClient> managementClientProducer;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployer;
    @Inject
    @ApplicationScoped
    private InstanceProducer<Context> jndiContext;
    @Inject
    @ContainerScoped
    protected InstanceProducer<ServerManager> serverManagerProducer;
    private final StandaloneDelegateProvider mccProvider = new StandaloneDelegateProvider();
    private ManagementClient managementClient = null;
    private ContainerDescription containerDescription = null;
    private URI authenticationConfig = null;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 5.0");
    }

    public void setup(T config) {
        ManagementClient client;
        this.containerConfig = config;
        String authenticationConfig = ((CommonContainerConfiguration)this.containerConfig).getAuthenticationConfig();
        if (authenticationConfig != null) {
            this.authenticationConfig = URI.create(authenticationConfig);
        }
        this.managementClient = client = new ManagementClient((ModelControllerClient)new DelegatingModelControllerClient((DelegatingModelControllerClient.DelegateProvider)this.mccProvider), (CommonContainerConfiguration)this.containerConfig);
        this.managementClientProducer.set((Object)client);
        this.archiveDeployer.set((Object)new ArchiveDeployer(client, ((CommonContainerConfiguration)config).getDeploymentFailurePattern()));
    }

    public final void start() throws LifecycleException {
        ModelControllerClientConfiguration.Builder clientConfigBuilder = new ModelControllerClientConfiguration.Builder().setProtocol(((CommonContainerConfiguration)this.containerConfig).getManagementProtocol()).setHostName(((CommonContainerConfiguration)this.containerConfig).getManagementAddress()).setPort(((CommonContainerConfiguration)this.containerConfig).getManagementPort()).setAuthenticationConfigUri(this.authenticationConfig);
        int connectionTimeout = ((CommonContainerConfiguration)this.containerConfig).getConnectionTimeout();
        if (connectionTimeout > 0) {
            clientConfigBuilder.setConnectionTimeout(connectionTimeout);
        }
        if (((CommonContainerConfiguration)this.containerConfig).getUsername() != null) {
            Authentication.username = ((CommonContainerConfiguration)this.containerConfig).getUsername();
            Authentication.password = ((CommonContainerConfiguration)this.containerConfig).getPassword();
            clientConfigBuilder.setHandler((CallbackHandler)Authentication.getCallbackHandler());
        }
        this.mccProvider.setDelegate(ModelControllerClient.Factory.create((ModelControllerClientConfiguration)clientConfigBuilder.build()));
        if (!(this instanceof CommonManagedDeployableContainer)) {
            StandaloneManager serverManager = ServerManager.builder().client(this.getManagementClient().getControllerClient()).process((ProcessHandle)ServerManager.findProcess().orElse(null)).standalone();
            this.serverManagerProducer.set((Object)serverManager.asManaged());
        }
        try {
            Properties jndiProps = new Properties();
            jndiProps.setProperty("java.naming.factory.url.pkgs", JBOSS_URL_PKG_PREFIX);
            this.jndiContext.set((Object)new InitialContext(jndiProps));
        }
        catch (NamingException ne) {
            throw new LifecycleException("Could not set JNDI Naming Context", (Throwable)ne);
        }
        try {
            this.startInternal();
        }
        catch (LifecycleException e) {
            this.safeCloseClient();
            throw e;
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    public final void stop() throws LifecycleException {
        try {
            this.stopInternal(null);
        }
        finally {
            this.safeCloseClient();
        }
    }

    public final void stop(Integer timeout) throws LifecycleException {
        try {
            this.stopInternal(timeout);
        }
        finally {
            this.safeCloseClient();
        }
    }

    protected abstract void stopInternal(Integer var1) throws LifecycleException;

    public ContainerDescription getContainerDescription() {
        if (this.containerDescription == null) {
            try {
                ManagementClient client = this.getManagementClient();
                if (client == null) {
                    return null;
                }
                this.containerDescription = ContainerDescription.lookup((ModelControllerClient)client.getControllerClient());
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).warn((Object)"Failed to lookup the container description.", (Throwable)e);
                this.containerDescription = new ContainerDescription(){

                    public String getProductName() {
                        return "WildFly";
                    }

                    public String getProductVersion() {
                        return "";
                    }

                    public String getReleaseVersion() {
                        return "";
                    }

                    public String getLaunchType() {
                        return "UNKNOWN";
                    }

                    public boolean isDomain() {
                        return false;
                    }
                };
            }
        }
        return this.containerDescription;
    }

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        if (this.managementClient == null) {
            throw new IllegalStateException("The container has not been setup. The client is not usable.");
        }
        return this.managementClient.getControllerClient();
    }

    protected boolean isOperationAttributeSupported(String operationName, String attributeName) throws IOException {
        return this.isOperationAttributeSupported(null, operationName, attributeName);
    }

    protected boolean isOperationAttributeSupported(ModelNode address, String operationName, String attributeName) throws IOException {
        ModelControllerClient client = this.getModelControllerClient();
        ModelNode op = address == null ? Operations.createOperation((String)READ_OPERATION_DESCRIPTION_OPERATION) : Operations.createOperation((String)READ_OPERATION_DESCRIPTION_OPERATION, (ModelNode)address);
        op.get("name").set(operationName);
        ModelNode result = client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)result)) {
            ModelNode params = Operations.readResult((ModelNode)result).get("request-properties");
            return params.keys().contains(attributeName);
        }
        String msg = address == null ? String.format("Failed to determine if attribute %s is supported for operation %s. %s", attributeName, operationName, Operations.getFailureDescription((ModelNode)result)) : String.format("Failed to determine if attribute %s is supported for operation %s:%s. %s", attributeName, CommonDeployableContainer.addressToCliString(address), operationName, Operations.getFailureDescription((ModelNode)result));
        throw new IllegalStateException(msg);
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String runtimeName = ((ArchiveDeployer)this.archiveDeployer.get()).deploy(archive);
        return this.getManagementClient().getProtocolMetaData(runtimeName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        ((ArchiveDeployer)this.archiveDeployer.get()).undeploy(archive.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("not implemented");
    }

    private void safeCloseClient() {
        try {
            ManagementClient client = this.managementClient;
            if (client != null) {
                client.reset();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).warn((Object)"Caught exception closing ManagementClient", (Throwable)e);
        }
        finally {
            this.mccProvider.setDelegate(null);
        }
    }

    private static String addressToCliString(ModelNode address) {
        if (address == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(32);
        for (Property property : address.asPropertyList()) {
            result.append('/').append(property.getName()).append('=').append(property.getValue().asString());
        }
        return result.toString();
    }

    private static class StandaloneDelegateProvider
    implements DelegatingModelControllerClient.DelegateProvider {
        private final AtomicReference<ModelControllerClient> delegate = new AtomicReference();

        private StandaloneDelegateProvider() {
        }

        void setDelegate(ModelControllerClient client) {
            this.delegate.set(client);
        }

        public ModelControllerClient getDelegate() {
            ModelControllerClient result = this.delegate.get();
            if (result == null) {
                throw new IllegalStateException("The container has not been started. The client is not usable.");
            }
            return result;
        }
    }
}

