/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.container.WildFlyArquillianConfiguration;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;

public class InContainerManagementClientProvider
implements ResourceProvider {
    private static final Lock lock = new ReentrantLock();
    private static ManagementClient current;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(ManagementClient.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(ArquillianResource arquillianResource, Annotation ... annotations) {
        lock.lock();
        try {
            if (current != null) {
                ManagementClient managementClient = current;
                return managementClient;
            }
            WildFlyArquillianConfiguration.getConfiguration().ifPresent(properties -> {
                String authenticationConfig;
                String protocol = properties.getProperty("management.protocol", "remote+http");
                String address = properties.getProperty("management.address", "localhost");
                int port = Integer.parseInt(properties.getProperty("management.port", "9990"));
                ModelControllerClientConfiguration.Builder builder = new ModelControllerClientConfiguration.Builder().setHostName(address).setPort(port).setProtocol(protocol);
                Authentication.username = properties.getProperty("username", "");
                Authentication.password = properties.getProperty("password", "");
                if (!Authentication.username.isEmpty()) {
                    builder.setHandler((CallbackHandler)Authentication.getCallbackHandler());
                }
                if ((authenticationConfig = properties.getProperty("authenticationConfig")) != null) {
                    builder.setAuthenticationConfigUri(URI.create(authenticationConfig));
                }
                current = new ManagementClient(ModelControllerClient.Factory.create((ModelControllerClientConfiguration)builder.build()), address, port, protocol);
            });
            ManagementClient managementClient = current;
            return managementClient;
        }
        finally {
            lock.unlock();
        }
    }

    public void cleanUp(@Observes AfterSuite afterSuite) {
        lock.lock();
        try {
            if (current != null) {
                current.close();
                current = null;
            }
        }
        finally {
            lock.unlock();
        }
    }
}

