/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.NetworkUtils;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class ManagementClient
implements Closeable {
    private static final Logger logger = Logger.getLogger(ManagementClient.class);
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String UNDERTOW = "undertow";
    private static final String REST = "jaxrs";
    private static final String NAME = "name";
    private static final String SERVLET = "servlet";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    private static final ModelNode UNDERTOW_SUBSYSTEM_ADDRESS = new ModelNode().add("subsystem", "undertow");
    private static final String REST_APPLICATION_PATH = "ArquillianRESTRunnerEE9";
    private final String mgmtAddress;
    private final int mgmtPort;
    private final String mgmtProtocol;
    private final ModelControllerClient client;
    private final CommonContainerConfiguration config;
    private boolean initialized = false;
    private URI webUri;
    private URI ejbUri;
    private ModelNode undertowSubsystem = null;
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private boolean undertowSubsystemPresent = false;
    private boolean jmxSubsystemPresent = false;
    private boolean closed = false;

    public ManagementClient(ModelControllerClient client, String mgmtAddress, int managementPort, String protocol) {
        this.client = Objects.requireNonNull(client, "Client must not be null");
        this.mgmtAddress = mgmtAddress;
        this.mgmtPort = managementPort;
        this.mgmtProtocol = protocol;
        this.config = null;
    }

    public ManagementClient(ModelControllerClient client, CommonContainerConfiguration config) {
        this.client = Objects.requireNonNull(client, "Client must not be null");
        this.mgmtAddress = config.getManagementAddress();
        this.mgmtPort = config.getManagementPort();
        this.mgmtProtocol = config.getManagementProtocol();
        this.config = config;
    }

    public ModelControllerClient getControllerClient() {
        this.checkState();
        return this.client;
    }

    void reset() {
        this.close();
        this.initialized = false;
        this.closed = false;
    }

    private void init() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ManagementClient.this.checkState();
                if (!ManagementClient.this.initialized) {
                    ManagementClient.this.initialized = true;
                    try {
                        URI webUri;
                        ModelNode op = Operations.createReadResourceOperation((ModelNode)UNDERTOW_SUBSYSTEM_ADDRESS, (boolean)true);
                        ModelNode result = ManagementClient.this.client.execute(op);
                        ManagementClient.this.undertowSubsystemPresent = Operations.isSuccessfulOutcome((ModelNode)result);
                        if (ManagementClient.this.undertowSubsystemPresent) {
                            ManagementClient.this.undertowSubsystem = Operations.readResult((ModelNode)result);
                        }
                        try {
                            webUri = new URI("http://localhost:8080");
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        if (ManagementClient.this.config != null && ManagementClient.this.config.getSocketBindingName() != null) {
                            webUri = ManagementClient.this.getBinding(ManagementClient.this.config.getSocketBindingName());
                        } else if (ManagementClient.this.undertowSubsystem != null && ManagementClient.this.undertowSubsystem.hasDefined("server")) {
                            List vhosts = ManagementClient.this.undertowSubsystem.get("server").asPropertyList();
                            ModelNode socketBinding = new ModelNode();
                            if (!vhosts.isEmpty()) {
                                socketBinding = ((Property)vhosts.get(0)).getValue().get(new String[]{"http-listener", "default"}).get("socket-binding");
                            }
                            if (socketBinding.isDefined()) {
                                webUri = ManagementClient.this.getBinding(socketBinding.asString());
                            }
                        }
                        ManagementClient.this.webUri = webUri;
                        try {
                            ManagementClient.this.ejbUri = new URI("http-remoting", webUri.getUserInfo(), webUri.getHost(), webUri.getPort(), null, null, null);
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(e);
                        }
                        op = Operations.createOperation((String)"read-children-names");
                        op.get("child-type").set("subsystem");
                        result = ManagementClient.this.client.execute(op);
                        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                            throw new RuntimeException("Failed to determine if the JMX subsystem is present: " + Operations.getFailureDescription((ModelNode)result).asString());
                        }
                        ManagementClient.this.jmxSubsystemPresent = Operations.readResult((ModelNode)result).asList().stream().map(ModelNode::asString).anyMatch("jmx"::equals);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not init arquillian protocol", e);
                    }
                }
                return null;
            }
        });
    }

    public URI getWebUri() {
        this.init();
        return this.webUri;
    }

    public ProtocolMetaData getProtocolMetaData(String deploymentName) {
        this.init();
        ProtocolMetaData metaData = new ProtocolMetaData();
        if (this.jmxSubsystemPresent) {
            metaData.addContext((Object)new JMXContext(this.getConnection()));
        }
        if (this.undertowSubsystemPresent) {
            URI webURI = this.getWebUri();
            HTTPContext context = new HTTPContext(webURI.getHost(), webURI.getPort(), "https".equalsIgnoreCase(webURI.getScheme()));
            metaData.addContext((Object)context);
            if (deploymentName != null) {
                try {
                    for (Servlet servlet : this.resolveContexts(deploymentName)) {
                        context.add(servlet);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return metaData;
    }

    public boolean isServerInRunningState() {
        this.checkState();
        try {
            ModelNode op = new ModelNode();
            op.get("operation").set("read-attribute");
            op.get("address").setEmptyList();
            op.get(NAME).set("server-state");
            ModelNode rsp = this.client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !"starting".equals(rsp.get("result").asString()) && !"stopping".equals(rsp.get("result").asString());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.client.close();
                this.closed = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not close connection", e);
            }
            finally {
                if (this.connector != null) {
                    try {
                        this.connector.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not close JMX connection", e);
                    }
                }
            }
        }
    }

    private static ModelNode defined(ModelNode node, String message) {
        if (!node.isDefined()) {
            throw new IllegalStateException(message);
        }
        return node;
    }

    private URI getBinding(String socketBinding) {
        String protocol = "http";
        String host = null;
        int port = -1;
        if (this.config != null) {
            host = this.config.getHost();
            port = this.config.getPort();
            protocol = this.config.getProtocol();
        }
        try {
            if (host == null || port < 0) {
                ModelNode sbgOp = new ModelNode();
                sbgOp.get("operation").set("read-children-names");
                sbgOp.get("child-type").set("socket-binding-group");
                ModelNode socketBindingGroups = this.executeForResult(sbgOp);
                String socketBindingGroupName = ((ModelNode)socketBindingGroups.asList().get(0)).asString();
                ModelNode operation = new ModelNode();
                operation.get("address").get("socket-binding-group").set(socketBindingGroupName);
                operation.get("address").get("socket-binding").set(socketBinding);
                operation.get("operation").set("read-resource");
                operation.get("include-runtime").set(true);
                ModelNode binding = this.executeForResult(operation);
                if (host == null) {
                    host = ManagementClient.formatIP(binding.get("bound-address").asString());
                }
                if (port < 0) {
                    port = ManagementClient.defined(binding.get("bound-port"), socketBindingGroupName + " -> " + socketBinding + " -> bound-port is undefined").asInt();
                }
            }
            return URI.create(protocol + "://" + NetworkUtils.formatPossibleIpv6Address(host) + ":" + port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String formatIP(String ip) {
        if (ip.contains(":") && ip.contains("%")) {
            ip = ip.split("%")[0];
        }
        if (ip.equals("0.0.0.0")) {
            logger.debug((Object)"WildFly is bound to 0.0.0.0 which is correct, setting client to 127.0.0.1");
            ip = "127.0.0.1";
        }
        return ip;
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private Collection<Servlet> resolveContexts(String deploymentName) throws IOException {
        ArrayList<Servlet> contexts = new ArrayList<Servlet>();
        if (this.isWebArchive(deploymentName)) {
            contexts.addAll(ManagementClient.resolveServletContexts(this.readDeploymentNode(deploymentName, null)));
        } else if (this.isEnterpriseArchive(deploymentName)) {
            contexts.addAll(ManagementClient.resolveServletContexts(this.readDeploymentNode(deploymentName, this.findWebDeployments(deploymentName))));
        }
        return contexts;
    }

    private Set<String> findWebDeployments(String deploymentName) throws IOException {
        ModelNode op = Operations.createOperation((String)"read-children-names", (ModelNode)Operations.createAddress((String[])new String[]{"deployment", deploymentName}));
        op.get("child-type").set(SUBDEPLOYMENT);
        ModelNode result = this.client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(String.format("Could not find sudeployments for %s: %s", deploymentName, Operations.getFailureDescription((ModelNode)result).asString()));
        }
        return Operations.readResult((ModelNode)result).asList().stream().map(ModelNode::asString).filter(this::isWebArchive).collect(Collectors.toSet());
    }

    private List<ModelNode> readDeploymentNode(String deploymentName, Iterable<String> subDeploymentNames) throws IOException {
        if (subDeploymentNames == null) {
            ModelNode operation = Operations.createReadResourceOperation((ModelNode)Operations.createAddress((String[])new String[]{"deployment", deploymentName, "subsystem"}));
            operation.get("recursive-depth").set(2);
            operation.get("include-runtime").set(true);
            ModelNode result = this.client.execute(operation);
            if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                throw new RuntimeException(Operations.getFailureDescription((ModelNode)result).asString());
            }
            return Collections.singletonList(ManagementClient.parseResult(result));
        }
        ArrayList<ModelNode> deployments = new ArrayList<ModelNode>();
        Operations.CompositeOperationBuilder builder = Operations.CompositeOperationBuilder.create();
        for (String subDeploymentName : subDeploymentNames) {
            ModelNode operation = Operations.createReadResourceOperation((ModelNode)Operations.createAddress((String[])new String[]{"deployment", deploymentName, SUBDEPLOYMENT, subDeploymentName, "subsystem"}));
            operation.get("recursive-depth").set(2);
            operation.get("include-runtime").set(true);
            builder.addStep(operation);
        }
        ModelNode result = this.client.execute(builder.build());
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new RuntimeException(Operations.getFailureDescription((ModelNode)result).asString());
        }
        for (Property property : Operations.readResult((ModelNode)result).asPropertyList()) {
            deployments.add(ManagementClient.parseResult(property.getValue()));
        }
        return deployments;
    }

    private static ModelNode parseResult(ModelNode result) {
        ModelNode model = new ModelNode();
        for (ModelNode subsystemResult : Operations.readResult((ModelNode)result).asList()) {
            ModelNode a = Operations.getOperationAddress((ModelNode)subsystemResult);
            for (Property property : a.asPropertyList()) {
                if (!"subsystem".equals(property.getName())) continue;
                if (UNDERTOW.equals(property.getValue().asString())) {
                    model.get(UNDERTOW).set(Operations.readResult((ModelNode)subsystemResult));
                    continue;
                }
                if (!REST.equals(property.getValue().asString())) continue;
                model.get(REST).set(Operations.readResult((ModelNode)subsystemResult));
            }
        }
        return model;
    }

    private static Collection<Servlet> resolveServletContexts(Iterable<ModelNode> deployments) {
        ArrayList<Servlet> contexts = new ArrayList<Servlet>();
        for (ModelNode deployment : deployments) {
            ModelNode rest;
            ModelNode undertow;
            if (!deployment.isDefined()) continue;
            String contextName = null;
            if (deployment.hasDefined(UNDERTOW) && (undertow = deployment.get(UNDERTOW)).hasDefined("context-root")) {
                contextName = ManagementClient.toContextName(undertow.get("context-root").asString());
                if (undertow.hasDefined(SERVLET)) {
                    for (ModelNode servletNode : undertow.get(SERVLET).asList()) {
                        for (String servletName : servletNode.keys()) {
                            contexts.add(new Servlet(servletName, contextName));
                        }
                    }
                }
                contexts.add(new Servlet("default", contextName));
            }
            if (!deployment.hasDefined(REST) || !(rest = deployment.get(REST)).isDefined() || !rest.hasDefined("rest-resource")) continue;
            for (Property restResource : rest.get("rest-resource").asPropertyList()) {
                ManagementClient.findRestServlet(restResource.getValue().get("rest-resource-paths"), contextName).ifPresent(contexts::add);
            }
        }
        return contexts;
    }

    private static String toContextName(String deploymentName) {
        if (deploymentName.isEmpty() || deploymentName.charAt(0) != '/') {
            return deploymentName;
        }
        return deploymentName.substring(1);
    }

    private static Optional<Servlet> findRestServlet(ModelNode resourcePaths, String servletContext) {
        if (resourcePaths.isDefined() && resourcePaths.getType() == ModelType.LIST) {
            for (ModelNode current : resourcePaths.asList()) {
                if (!current.hasDefined("resource-methods")) continue;
                for (ModelNode resourceMethod : current.get("resource-methods").asList()) {
                    String rawValue = resourceMethod.asString();
                    if (!rawValue.contains(REST_APPLICATION_PATH)) continue;
                    return Optional.of(new Servlet(REST_APPLICATION_PATH, ManagementClient.toContextName(servletContext)));
                }
            }
        }
        return Optional.empty();
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        this.checkState();
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            logger.error((Object)("Operation " + String.valueOf(operation) + " did not succeed. Result was " + String.valueOf(result)));
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    private MBeanServerConnection getConnection() {
        MBeanServerConnection connection = this.connection;
        if (connection == null) {
            try {
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (Authentication.username != null && !Authentication.username.isEmpty()) {
                    env.put(CallbackHandler.class.getName(), Authentication.getCallbackHandler());
                }
                if (this.config.getAuthenticationConfig() != null) {
                    env.put("wildfly.config.url", this.config.getAuthenticationConfig());
                }
                JMXServiceURL serviceURL = this.getRemoteJMXURL();
                JMXConnector connector = this.connector = JMXConnectorFactory.connect(serviceURL, env);
                connection = this.connection = new MBeanConnectionProxy(connector.getMBeanServerConnection());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return connection;
    }

    public JMXServiceURL getRemoteJMXURL() {
        try {
            if ("http-remoting".equals(this.mgmtProtocol) || "remote+http".equals(this.mgmtProtocol)) {
                return new JMXServiceURL("service:jmx:remote+http://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
            }
            if (this.mgmtProtocol.equals("https-remoting")) {
                return new JMXServiceURL("service:jmx:remote+https://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
            }
            return new JMXServiceURL("service:jmx:remoting-jmx://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + String.valueOf(this), e);
        }
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public String getMgmtAddress() {
        return NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress);
    }

    public String getMgmtProtocol() {
        return this.mgmtProtocol;
    }

    public URI getRemoteEjbURL() {
        this.init();
        return this.ejbUri;
    }

    private void checkState() {
        if (this.closed) {
            throw new IllegalStateException("The client connection has been closed.");
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        UnSuccessfulOperationException(String message) {
            super(message);
        }
    }

    private class MBeanConnectionProxy
    implements MBeanServerConnection {
        private MBeanServerConnection connection;

        private MBeanConnectionProxy(MBeanServerConnection connection) {
            this.connection = connection;
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, loaderName);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, params, signature);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            this.checkConnection();
            return this.connection.createMBean(className, name, loaderName, params, signature);
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            this.checkConnection();
            this.connection.unregisterMBean(name);
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            try {
                return this.connection.getObjectInstance(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getObjectInstance(name);
            }
        }

        @Override
        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
            try {
                return this.connection.queryMBeans(name, query);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.queryMBeans(name, query);
            }
        }

        @Override
        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
            try {
                return this.connection.queryNames(name, query);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.queryNames(name, query);
            }
        }

        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            try {
                return this.connection.isRegistered(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.isRegistered(name);
            }
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            try {
                return this.connection.getMBeanCount();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getMBeanCount();
            }
        }

        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            try {
                return this.connection.getAttribute(name, attribute);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getAttribute(name, attribute);
            }
        }

        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            try {
                return this.connection.getAttributes(name, attributes);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getAttributes(name, attributes);
            }
        }

        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.checkConnection();
            this.connection.setAttribute(name, attribute);
        }

        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            this.checkConnection();
            return this.connection.setAttributes(name, attributes);
        }

        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            this.checkConnection();
            return this.connection.invoke(name, operationName, params, signature);
        }

        @Override
        public String getDefaultDomain() throws IOException {
            try {
                return this.connection.getDefaultDomain();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getDefaultDomain();
            }
        }

        @Override
        public String[] getDomains() throws IOException {
            try {
                return this.connection.getDomains();
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getDomains();
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                this.connection.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.addNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            try {
                this.connection.addNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.addNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener);
                }
                throw e;
            }
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            try {
                this.connection.removeNotificationListener(name, listener, filter, handback);
            }
            catch (IOException e) {
                if (!this.checkConnection()) {
                    this.connection.removeNotificationListener(name, listener, filter, handback);
                }
                throw e;
            }
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            try {
                return this.connection.getMBeanInfo(name);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.getMBeanInfo(name);
            }
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            try {
                return this.connection.isInstanceOf(name, className);
            }
            catch (IOException e) {
                this.checkConnection();
                return this.connection.isInstanceOf(name, className);
            }
        }

        private boolean checkConnection() {
            try {
                this.connection.getDefaultDomain();
                return true;
            }
            catch (IOException ioe) {
                logger.debug((Object)"JMX connection error.", (Throwable)ioe);
                this.connection = this.reconnect();
                return false;
            }
        }

        private MBeanServerConnection reconnect() {
            try {
                HashMap<String, Authentication.CallbackHandler> env = new HashMap<String, Authentication.CallbackHandler>();
                env.put(CallbackHandler.class.getName(), Authentication.getCallbackHandler());
                JMXConnector connector = ManagementClient.this.connector = JMXConnectorFactory.connect(ManagementClient.this.getRemoteJMXURL(), env);
                this.connection = connector.getMBeanServerConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.connection;
        }
    }
}

