/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class WildFlyArquillianConfiguration {
    private static final String CONFIG_FILE = "wildfly-arquillian-config.properties";

    public static void addConfiguration(Map<String, String> config, Archive<?> archive) {
        String authenticationConfig;
        String password;
        if (archive.get(CONFIG_FILE) != null) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("management.protocol", config.getOrDefault("managementProtocol", "remote+http"));
        properties.setProperty("management.address", config.getOrDefault("managementAddress", "localhost"));
        properties.setProperty("management.port", config.getOrDefault("managementPort", "9990"));
        String username = config.get("username");
        if (username != null) {
            properties.setProperty("username", username);
        }
        if ((password = config.get("password")) != null) {
            properties.setProperty("password", password);
        }
        if ((authenticationConfig = config.get("authenticationConfig")) != null) {
            properties.setProperty("authenticationConfig", authenticationConfig);
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            properties.store(out, "");
            ByteArrayAsset asset = new ByteArrayAsset(out.toByteArray());
            if (Validate.isArchiveOfType(WebArchive.class, archive)) {
                archive.add((Asset)asset, "WEB-INF/classes/wildfly-arquillian-config.properties");
            } else {
                archive.add((Asset)asset, CONFIG_FILE);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Optional<Properties> getConfiguration() {
        ClassLoader classLoader = WildFlyArquillianConfiguration.getClassLoader();
        URL resourceUrl = classLoader.getResource(CONFIG_FILE);
        if (resourceUrl != null) {
            Optional<Properties> optional;
            block9: {
                InputStream in = resourceUrl.openStream();
                try {
                    Properties properties = new Properties();
                    properties.load(in);
                    optional = Optional.of(properties);
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                in.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = WildFlyArquillianConfiguration.class.getClassLoader();
            }
            return classLoader;
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = WildFlyArquillianConfiguration.class.getClassLoader();
            }
            return classLoader;
        });
    }
}

