/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.bootable;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jboss.as.arquillian.container.CommonManagedDeployableContainer;
import org.jboss.as.arquillian.container.ParameterUtils;
import org.jboss.as.arquillian.container.bootable.BootableContainerConfiguration;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;

public final class BootableDeployableContainer
extends CommonManagedDeployableContainer<BootableContainerConfiguration> {
    private final Logger log = Logger.getLogger((String)BootableDeployableContainer.class.getName());

    public Class<BootableContainerConfiguration> getConfigurationClass() {
        return BootableContainerConfiguration.class;
    }

    protected CommandBuilder createCommandBuilder(BootableContainerConfiguration config) {
        BootableJarCommandBuilder commandBuilder = BootableJarCommandBuilder.of((String)config.getJarFile());
        String path = config.getInstallDir();
        if (path != null) {
            Path installDir = Paths.get(path, new String[0]);
            if (Files.notExists(installDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(installDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Failed to create directory %s", installDir), e);
                }
            }
            commandBuilder.setInstallDir(installDir);
        }
        String javaOpts = config.getJavaVmArguments();
        String jbossArguments = config.getJbossArguments();
        commandBuilder.setJavaHome(config.getJavaHome());
        if (javaOpts != null && !javaOpts.trim().isEmpty()) {
            commandBuilder.setJavaOptions((Iterable)ParameterUtils.splitParams((String)javaOpts));
        }
        if (config.isEnableAssertions()) {
            commandBuilder.addJavaOption("-ea");
        }
        if (jbossArguments != null && !jbossArguments.trim().isEmpty()) {
            commandBuilder.addServerArguments((Iterable)ParameterUtils.splitParams((String)jbossArguments));
        }
        return commandBuilder;
    }

    protected Logger getLogger() {
        return this.log;
    }
}

