/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.domain.CommonDomainDeployableContainer;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.arquillian.container.domain.managed.ManagedDomainContainerConfiguration;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;

public class ManagedDomainDeployableContainer
extends CommonDomainDeployableContainer<ManagedDomainContainerConfiguration> {
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String DATA_DIR = "data";
    static final String SERVERS_DIR = "servers";
    private final Logger log = Logger.getLogger(ManagedDomainDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    public Class<ManagedDomainContainerConfiguration> getConfigurationClass() {
        return ManagedDomainContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        ManagedDomainContainerConfiguration config = (ManagedDomainContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            String serverArgs;
            String modulesPath;
            DomainCommandBuilder commandBuilder = DomainCommandBuilder.of((String)config.getJbossHome(), (String)config.getJavaHome());
            if (config.getJavaVmArguments() != null) {
                String[] javaOpts = config.getJavaVmArguments().split("\\s+");
                commandBuilder.setProcessControllerJavaOptions(javaOpts).setHostControllerJavaOptions(javaOpts);
            }
            if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
                ManagedDomainDeployableContainer.setupCleanServerDirectories(commandBuilder, config.getCleanServerBaseDir());
            }
            if ((modulesPath = config.getModulePath()) != null && !modulesPath.isEmpty()) {
                commandBuilder.addModuleDirs(modulesPath.split(Pattern.quote(File.pathSeparator)));
            }
            if (config.isEnableAssertions()) {
                commandBuilder.addHostControllerJavaOption("-ea").addProcessControllerJavaOption("-ea");
            }
            if (config.getDomainConfig() != null) {
                commandBuilder.setDomainConfiguration(config.getDomainConfig());
            }
            if (config.getHostConfig() != null) {
                commandBuilder.setHostConfiguration(config.getHostConfig());
            }
            if ((serverArgs = config.getJbossArguments()) != null) {
                commandBuilder.addServerArguments(serverArgs.split("\\s+"));
            }
            commandBuilder.addProcessControllerJavaOption("-Djboss.home.dir=" + commandBuilder.getWildFlyHome());
            this.log.info("Starting container with: " + commandBuilder.build());
            this.process = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true).launch();
            new Thread(new ConsoleConsumer()).start();
            this.shutdownThread = ProcessHelper.addShutdownHook((Process)this.process);
            long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                long before = System.currentTimeMillis();
                serverAvailable = this.getManagementClient().isDomainInRunningState();
                timeout -= System.currentTimeMillis() - before;
                if (serverAvailable) continue;
                if (ProcessHelper.processHasDied((Process)this.process)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                ProcessHelper.destroyProcess((Process)this.process);
                throw new TimeoutException(String.format("Managed Domain server was not started within [%d] s", config.getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected void waitForStart(Domain domain, ManagementClient client) throws LifecycleException {
        this.waitForAutoStartServersToStart(domain, client);
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                Thread shutdown = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(((ManagedDomainContainerConfiguration)ManagedDomainDeployableContainer.this.getContainerConfiguration()).getStopTimeoutInSeconds() * 1000);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        if (ManagedDomainDeployableContainer.this.process != null) {
                            ManagedDomainDeployableContainer.this.process.destroy();
                        }
                    }
                });
                shutdown.start();
                ModelNode op = new ModelNode();
                op.get("operation").set("read-attribute");
                op.get("name").set("local-host-name");
                ModelNode result = this.getManagementClient().getControllerClient().execute(op, null);
                String hostName = result.get("result").asString();
                op = new ModelNode();
                op.get("operation").set("shutdown");
                ModelNode address = op.get("address");
                address.add("host", hostName);
                this.getManagementClient().getControllerClient().executeAsync(op, null);
                this.process.waitFor();
                this.process = null;
                shutdown.interrupt();
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private void waitForAutoStartServersToStart(Domain domain, ManagementClient client) {
        long timeout;
        Set servers = domain.getAutoStartServers();
        long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getAutoServerStartupTimeoutInSeconds();
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L && servers.size() > 0; timeout -= sleep) {
            Iterator serverIterator = servers.iterator();
            while (serverIterator.hasNext()) {
                Domain.Server server = (Domain.Server)serverIterator.next();
                if (!client.isServerStarted(server)) continue;
                serverIterator.remove();
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for servers to start", e);
            }
        }
        if (timeout <= 0L) {
            throw new RuntimeException("Auto started servers did not start within set timeout [autoServerStartupTimeoutInSeconds=" + startupTimeout + "]. " + servers);
        }
    }

    private static void setupCleanServerDirectories(DomainCommandBuilder commandBuilder, String cleanServerBaseDirPath) throws IOException {
        Path cleanBase = cleanServerBaseDirPath != null ? Paths.get(cleanServerBaseDirPath, new String[0]) : Files.createTempDirectory(TEMP_CONTAINER_DIRECTORY, new FileAttribute[0]);
        if (Files.notExists(cleanBase, new LinkOption[0])) {
            throw ManagedDomainDeployableContainer.serverBaseDirectoryDoesNotExist(cleanBase.toFile());
        }
        if (!Files.isDirectory(cleanBase, new LinkOption[0])) {
            throw ManagedDomainDeployableContainer.serverBaseDirectoryIsNotADirectory(cleanBase.toFile());
        }
        Path currentConfigDir = commandBuilder.getConfigurationDirectory();
        Path configDir = cleanBase.resolve(CONFIG_DIR);
        ManagedDomainDeployableContainer.copyDir(currentConfigDir, configDir);
        Path currentDataDir = commandBuilder.getBaseDirectory().resolve(DATA_DIR);
        if (Files.exists(currentDataDir, new LinkOption[0])) {
            ManagedDomainDeployableContainer.copyDir(currentDataDir, cleanBase.resolve(DATA_DIR));
        }
        commandBuilder.setBaseDirectory(cleanBase);
        commandBuilder.setConfigurationDirectory(configDir);
    }

    static IllegalStateException serverBaseDirectoryDoesNotExist(File f) {
        return new IllegalStateException(String.format("Server base directory does not exist: %s", f));
    }

    static IllegalStateException serverBaseDirectoryIsNotADirectory(File file) {
        return new IllegalStateException(String.format("Server base directory is not a directory: %s", file));
    }

    private static void copyDir(final Path from, final Path to) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.copy(dir, to.resolve(from.relativize(dir)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, to.resolve(from.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDomainDeployableContainer.this.process.getInputStream();
            boolean writeOutput = ((ManagedDomainContainerConfiguration)ManagedDomainDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

