/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.domain.CommonDomainDeployableContainer;
import org.jboss.as.arquillian.container.domain.ParameterUtils;
import org.jboss.as.arquillian.container.domain.managed.ManagedDomainContainerConfiguration;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;

public class ManagedDomainDeployableContainer
extends CommonDomainDeployableContainer<ManagedDomainContainerConfiguration> {
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    static final String CONFIG_DIR = "configuration";
    static final String DATA_DIR = "data";
    static final String SERVERS_DIR = "servers";
    private final Logger log = Logger.getLogger(ManagedDomainDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    public Class<ManagedDomainContainerConfiguration> getConfigurationClass() {
        return ManagedDomainContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        ManagedDomainContainerConfiguration config = (ManagedDomainContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            String serverArgs;
            String modulesPath;
            DomainCommandBuilder commandBuilder = DomainCommandBuilder.of((String)config.getJbossHome(), (String)config.getJavaHome());
            String javaVmArguments = config.getJavaVmArguments();
            if (javaVmArguments != null && !javaVmArguments.trim().isEmpty()) {
                List javaOpts = ParameterUtils.splitParams((String)javaVmArguments);
                commandBuilder.setProcessControllerJavaOptions((Iterable)javaOpts).setHostControllerJavaOptions((Iterable)javaOpts);
            }
            if ((modulesPath = config.getModulePath()) != null && !modulesPath.isEmpty()) {
                commandBuilder.setModuleDirs(modulesPath.split(Pattern.quote(File.pathSeparator)));
            }
            if (config.isEnableAssertions()) {
                commandBuilder.addHostControllerJavaOption("-ea").addProcessControllerJavaOption("-ea");
            }
            if (config.getDomainConfig() != null) {
                commandBuilder.setDomainConfiguration(config.getDomainConfig());
            }
            if (config.getHostConfig() != null) {
                commandBuilder.setHostConfiguration(config.getHostConfig());
            }
            if ((serverArgs = config.getJbossArguments()) != null && !serverArgs.trim().isEmpty()) {
                commandBuilder.addServerArguments((Iterable)ParameterUtils.splitParams((String)serverArgs));
            }
            if (config.isSetupCleanServerBaseDir() || config.getCleanServerBaseDir() != null) {
                this.setupCleanServerDirectories(commandBuilder, config.getCleanServerBaseDir());
            }
            commandBuilder.addProcessControllerJavaOption("-Djboss.home.dir=" + commandBuilder.getWildFlyHome());
            this.log.info("Starting container with: " + commandBuilder.build());
            Process process = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true).launch();
            new Thread(new ConsoleConsumer(process, config.isOutputToConsole())).start();
            this.shutdownThread = ProcessHelper.addShutdownHook((Process)process);
            long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                long before = System.currentTimeMillis();
                serverAvailable = this.getManagementClient().isDomainInRunningState();
                timeout -= System.currentTimeMillis() - before;
                if (serverAvailable) continue;
                if (ProcessHelper.processHasDied((Process)process)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                ProcessHelper.destroyProcess((Process)process);
                throw new TimeoutException(String.format("Managed Domain server was not started within [%d] s", config.getStartupTimeoutInSeconds()));
            }
            this.process = process;
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        Process process = this.process;
        this.process = null;
        try {
            if (process != null) {
                ModelNode op = Operations.createReadAttributeOperation((ModelNode)new ModelNode().setEmptyList(), (String)"local-host-name");
                ModelNode result = this.getManagementClient().getControllerClient().execute(op, null);
                if (Operations.isSuccessfulOutcome((ModelNode)result)) {
                    String hostName = Operations.readResult((ModelNode)result).asString();
                    op = Operations.createOperation((String)"shutdown", (ModelNode)Operations.createAddress((String[])new String[]{"host", hostName}));
                    this.getManagementClient().getControllerClient().executeAsync(op, null);
                }
                if (!process.waitFor(((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getStopTimeoutInSeconds(), TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                }
            }
        }
        catch (Exception e) {
            try {
                ProcessHelper.destroyProcess((Process)process);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private void setupCleanServerDirectories(DomainCommandBuilder commandBuilder, String cleanServerBaseDirPath) throws IOException {
        Path cleanBase;
        if (cleanServerBaseDirPath != null) {
            cleanBase = Paths.get(cleanServerBaseDirPath, new String[0]);
            if (Files.exists(cleanBase, new LinkOption[0]) && !ManagedDomainDeployableContainer.deleteDir(cleanBase)) {
                this.log.warning(String.format("Clean directory %s was not empty when copied. Previous data will be lost.", cleanBase));
            }
            Files.createDirectories(cleanBase, new FileAttribute[0]);
        } else {
            cleanBase = Files.createTempDirectory(TEMP_CONTAINER_DIRECTORY, new FileAttribute[0]);
        }
        if (Files.notExists(cleanBase, new LinkOption[0])) {
            throw ManagedDomainDeployableContainer.serverBaseDirectoryDoesNotExist(cleanBase.toFile());
        }
        if (!Files.isDirectory(cleanBase, new LinkOption[0])) {
            throw ManagedDomainDeployableContainer.serverBaseDirectoryIsNotADirectory(cleanBase.toFile());
        }
        Path currentConfigDir = commandBuilder.getConfigurationDirectory();
        Path configDir = cleanBase.resolve(CONFIG_DIR);
        ManagedDomainDeployableContainer.copyDir(currentConfigDir, configDir);
        Path currentDataDir = commandBuilder.getBaseDirectory().resolve(DATA_DIR);
        if (Files.exists(currentDataDir, new LinkOption[0])) {
            ManagedDomainDeployableContainer.copyDir(currentDataDir, cleanBase.resolve(DATA_DIR));
        }
        commandBuilder.setBaseDirectory(cleanBase);
        commandBuilder.setConfigurationDirectory(configDir);
    }

    static IllegalStateException serverBaseDirectoryDoesNotExist(File f) {
        return new IllegalStateException(String.format("Server base directory does not exist: %s", f));
    }

    static IllegalStateException serverBaseDirectoryIsNotADirectory(File file) {
        return new IllegalStateException(String.format("Server base directory is not a directory: %s", file));
    }

    private static void copyDir(final Path from, final Path to) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.copy(dir, to.resolve(from.relativize(dir)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, to.resolve(from.relativize(file)), new CopyOption[0]);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean deleteDir(final Path toDelete) throws IOException {
        final AtomicBoolean empty = new AtomicBoolean(true);
        Files.walkFileTree(toDelete, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                if (!dir.equals(toDelete)) {
                    empty.compareAndSet(true, false);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                empty.compareAndSet(true, false);
                return FileVisitResult.CONTINUE;
            }
        });
        return empty.get();
    }

    private class ConsoleConsumer
    implements Runnable {
        private final Process process;
        private final boolean writeOutput;

        private ConsoleConsumer(Process process, boolean writeOutput) {
            this.process = process;
            this.writeOutput = writeOutput;
        }

        @Override
        public void run() {
            InputStream stream = this.process.getInputStream();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!this.writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

