/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;

public class InContainerManagementClientProvider
implements ResourceProvider {
    private static ManagementClient current;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(ManagementClient.class);
    }

    public synchronized Object lookup(ArquillianResource arquillianResource, Annotation ... annotations) {
        if (current != null) {
            return current;
        }
        URL resourceUrl = this.getClass().getClassLoader().getResource("META-INF/org.jboss.as.managementConnectionProps");
        if (resourceUrl != null) {
            InputStream in = null;
            try {
                in = resourceUrl.openStream();
                ObjectInputStream inputStream = new ObjectInputStream(in);
                String managementPort = (String)inputStream.readObject();
                String address = (String)inputStream.readObject();
                String protocol = (String)inputStream.readObject();
                if (address == null) {
                    address = "localhost";
                }
                if (managementPort == null) {
                    managementPort = "9990";
                }
                if (protocol == null) {
                    protocol = "http-remoting";
                }
                ModelControllerClient modelControllerClient = null;
                int port = Integer.parseInt(managementPort);
                modelControllerClient = ModelControllerClient.Factory.create((String)protocol, (String)address, (int)port, (CallbackHandler)Authentication.getCallbackHandler());
                current = new ManagementClient(modelControllerClient, address, port, protocol);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return current;
    }

    public synchronized void cleanUp(@Observes AfterSuite afterSuite) {
        if (current != null) {
            current.close();
            current = null;
        }
    }
}

