/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ContextManager;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.SetupAction;

public class ContextManagerBuilder {
    private final List<SetupAction> setupActions = new ArrayList<SetupAction>();
    private final ArquillianConfig config;

    ContextManagerBuilder(ArquillianConfig config) {
        this.config = config;
    }

    public ContextManagerBuilder add(SetupAction action) {
        this.setupActions.add(action);
        return this;
    }

    public ContextManagerBuilder addAll(DeploymentUnit deploymentUnit) {
        List actions = (List)deploymentUnit.getAttachment(Attachments.SETUP_ACTIONS);
        if (actions != null) {
            this.setupActions.addAll(actions);
        }
        return this;
    }

    public ContextManager build() {
        return new ContextManager(this.config, this.setupActions);
    }
}

