/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeStop;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.protocol.jmx.ExtendedJMXProtocol;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.plugin.tools.ContainerDescription;

public class ArquillianServiceDeployer {
    @Inject
    @ContainerScoped
    private Instance<ManagementClient> managementClientInstance;
    private static final Logger log = Logger.getLogger(ArquillianServiceDeployer.class);
    private Set<String> serviceArchiveDeployed = new HashSet<String>();

    public synchronized void doServiceDeploy(@Observes(precedence=1) BeforeDeploy event, Container container, ExtendedJMXProtocol.ServiceArchiveHolder archiveHolder) {
        if (this.serviceArchiveDeployed.contains(container.getName())) {
            archiveHolder.deploymentExistsAndRemove(event.getDeployment().getName());
            return;
        }
        if (archiveHolder.deploymentExistsAndRemove(event.getDeployment().getName())) {
            try {
                ManagementClient client = (ManagementClient)this.managementClientInstance.get();
                ContainerDescription containerDescription = ContainerDescription.lookup((ModelControllerClient)client.getControllerClient());
                if (containerDescription.getModelVersion().major() < 7) {
                    String productName = containerDescription.getProductName();
                    if (productName == null) {
                        productName = "WildFly";
                    }
                    String productVersion = containerDescription.getProductVersion();
                    StringBuilder msg = new StringBuilder(64).append(productName);
                    if (productVersion != null) {
                        msg.append(' ').append(productVersion);
                    }
                    msg.append(" does not meet the minimum required version");
                    if (productName.contains("WildFly")) {
                        msg.append(" of 13.0.0.Final.");
                    } else if (productName.contains("EAP")) {
                        msg.append(" of 7.2.0.GA.");
                    } else {
                        msg.append('.');
                    }
                    throw new RuntimeException(msg.toString());
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to determine the version of the running container.", (Throwable)e);
            }
            JavaArchive serviceArchive = (JavaArchive)archiveHolder.getArchive();
            try {
                log.infof("Deploy arquillian service: %s", (Object)serviceArchive);
                DeployableContainer deployableContainer = container.getDeployableContainer();
                deployableContainer.deploy((Archive)serviceArchive);
                this.serviceArchiveDeployed.add(container.getName());
            }
            catch (Throwable th) {
                log.error((Object)"Cannot deploy arquillian service", th);
            }
        }
    }

    public synchronized void undeploy(@Observes BeforeStop event, Container container, ExtendedJMXProtocol.ServiceArchiveHolder archiveHolder) {
        if (this.serviceArchiveDeployed.contains(container.getName())) {
            try {
                Archive<?> serviceArchive = archiveHolder.getArchive();
                log.infof("Undeploy arquillian service: %s", serviceArchive);
                DeployableContainer deployableContainer = container.getDeployableContainer();
                deployableContainer.undeploy(serviceArchive);
                this.serviceArchiveDeployed.remove(container.getName());
            }
            catch (Throwable th) {
                log.error((Object)"Cannot undeploy arquillian service", th);
            }
        }
    }
}

