/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.protocol.jmx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.vfs.VirtualFile;

public class TestDescription {
    private static final String PATH = "/META-INF/test-description.properties";
    private static final String TARGET_CONTAINER = "org.jboss.as.arquillian.protocol.jmx.target.container";
    private static final String ARQ_DEPLOYMENT_NAME = "org.jboss.as.arquillian.protocol.jmx.arq.deployment.name";
    private static final String DEPLOYMENT_NAME = "org.jboss.as.arquillian.protocol.jmx.deployment.name";
    private static final Filter<ArchivePath> ROOT_FILTER = p -> p.getParent() == null || p.getParent().get().equals("/");
    private final Properties properties;

    private TestDescription(Properties properties) {
        this.properties = properties;
    }

    public static TestDescription from(DeploymentUnit deploymentUnit) {
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile testDescription = resourceRoot.getRoot().getChild(PATH);
        Properties properties = new Properties();
        if (testDescription != null && testDescription.exists()) {
            try (InputStream in = testDescription.openStream();){
                properties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new TestDescription(properties);
    }

    public static void addTestDescription(TestDeployment testDeployment) {
        Archive archive;
        String targetContainer = null;
        String arqDeploymentName = null;
        if (testDeployment.getTargetDescription() != null) {
            targetContainer = testDeployment.getTargetDescription().getName();
        }
        if (testDeployment.getDeploymentName() != null) {
            arqDeploymentName = testDeployment.getDeploymentName();
        }
        if ((archive = testDeployment.getApplicationArchive()) instanceof EnterpriseArchive) {
            EnterpriseArchive ear = (EnterpriseArchive)archive;
            Map modules = ear.getContent(ROOT_FILTER);
            for (Node module : modules.values()) {
                if (!(module.getAsset() instanceof ArchiveAsset)) continue;
                Archive moduleArchive = ((ArchiveAsset)module.getAsset()).getArchive();
                TestDescription.addTestDescription(moduleArchive, targetContainer, arqDeploymentName);
            }
        }
        TestDescription.addTestDescription(archive, targetContainer, arqDeploymentName);
    }

    public Optional<String> targetContainer() {
        return Optional.ofNullable(this.properties.getProperty(TARGET_CONTAINER));
    }

    public String deploymentName() {
        return this.properties.getProperty(DEPLOYMENT_NAME);
    }

    public Optional<String> arquillianDeploymentName() {
        return Optional.ofNullable(this.properties.getProperty(ARQ_DEPLOYMENT_NAME));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestDescription)) {
            return false;
        }
        TestDescription other = (TestDescription)o;
        return Objects.equals(this.targetContainer(), other.targetContainer()) && Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.arquillianDeploymentName(), other.arquillianDeploymentName());
    }

    public int hashCode() {
        return Objects.hash(this.targetContainer(), this.deploymentName(), this.arquillianDeploymentName());
    }

    public String toString() {
        return "TestDescription [targetContainer=" + String.valueOf(this.targetContainer()) + ", deploymentName=" + this.deploymentName() + ", arquillianDeploymentName=" + String.valueOf(this.arquillianDeploymentName()) + "]";
    }

    private static void addTestDescription(Archive<?> archive, String targetContainer, String arqDeploymentName) {
        try {
            Properties properties = new Properties();
            if (archive.contains(PATH)) {
                try (InputStream in = archive.delete(PATH).getAsset().openStream();){
                    properties.load(new InputStreamReader(in, StandardCharsets.UTF_8));
                }
            }
            if (targetContainer != null) {
                properties.put(TARGET_CONTAINER, targetContainer);
            }
            if (arqDeploymentName != null) {
                properties.put(ARQ_DEPLOYMENT_NAME, arqDeploymentName);
            }
            properties.put(DEPLOYMENT_NAME, archive.getName());
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                properties.store(out, null);
                archive.add((Asset)new ByteArrayAsset(out.toByteArray()), PATH);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

