/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianConfigBuilder;
import org.jboss.as.arquillian.service.ContextManager;
import org.jboss.as.arquillian.service.ContextManagerBuilder;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ArquillianService
implements Service {
    public static final String TEST_CLASS_PROPERTY = "org.jboss.as.arquillian.testClass";
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"arquillian", "testrunner"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private final Supplier<MBeanServer> mBeanServerSupplier;
    private final Consumer<ArquillianService> arquillianServiceConsumer;
    private final Set<ArquillianConfig> deployedTests = new HashSet<ArquillianConfig>();
    private volatile JMXTestRunner jmxTestRunner;
    private volatile LifecycleListener listener;

    private ArquillianService(Supplier<MBeanServer> mBeanServerSupplier, Consumer<ArquillianService> arquillianServiceConsumer) {
        this.mBeanServerSupplier = mBeanServerSupplier;
        this.arquillianServiceConsumer = arquillianServiceConsumer;
    }

    public static void addService(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME);
        builder.setInstance((Service)new ArquillianService(builder.requires(MBeanServerService.SERVICE_NAME), builder.provides(new ServiceName[]{SERVICE_NAME})));
        builder.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        log.debugf("Starting Arquillian Test Runner", new Object[0]);
        this.arquillianServiceConsumer.accept(this);
        MBeanServer mbeanServer = this.mBeanServerSupplier.get();
        try {
            this.jmxTestRunner = new ExtendedJMXTestRunner(new ThreadLocal<ArquillianConfig>());
            this.jmxTestRunner.registerMBean(mbeanServer);
        }
        catch (Throwable t) {
            throw new StartException("Failed to start Arquillian Test Runner", t);
        }
        this.listener = new ArquillianListener(context.getChildTarget());
        context.getController().getServiceContainer().addListener(this.listener);
    }

    public synchronized void stop(StopContext context) {
        log.debugf("Stopping Arquillian Test Runner", new Object[0]);
        try {
            if (this.jmxTestRunner != null) {
                this.jmxTestRunner.unregisterMBean(this.mBeanServerSupplier.get());
            }
        }
        catch (Exception ex) {
            log.errorf((Throwable)ex, "Cannot stop Arquillian Test Runner", new Object[0]);
        }
        context.getController().getServiceContainer().removeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Register Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.add(arqConfig);
            this.deployedTests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterArquillianConfig(ArquillianConfig arqConfig) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            log.debugf("Unregister Arquillian config: %s", (Object)arqConfig.getServiceName());
            this.deployedTests.remove(arqConfig);
        }
    }

    private ArquillianConfig getArquillianConfig(String className, long timeout) {
        return this.getArquillianConfig(className, null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArquillianConfig getArquillianConfig(String className, String methodName, long timeout) {
        Set<ArquillianConfig> set = this.deployedTests;
        synchronized (set) {
            if (methodName == null && this.deployedTests.size() > 1) {
                log.warn((Object)"An attempt was made to lookup an Arquillian configuration with more than one deployed test. This may result in unexpected behavior.");
            }
            log.debugf("Getting Arquillian config for: %s", (Object)className);
            for (ArquillianConfig arqConfig : this.deployedTests) {
                boolean supports = methodName == null ? arqConfig.supports(className) : arqConfig.supports(className, methodName);
                if (!supports) continue;
                log.debugf("Found Arquillian config for class %s and method %s", (Object)className, (Object)methodName);
                return arqConfig;
            }
            if (timeout <= 0L) {
                throw new IllegalStateException("Cannot obtain Arquillian config for: " + className);
            }
            try {
                log.debugf("Waiting on Arquillian config for: %s", (Object)className);
                this.deployedTests.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getArquillianConfig(className, methodName, -1L);
    }

    private class ExtendedJMXTestRunner
    extends JMXTestRunner {
        private final ThreadLocal<ArquillianConfig> configHolder;

        ExtendedJMXTestRunner(ThreadLocal<ArquillianConfig> configHolder) {
            super((JMXTestRunner.TestClassLoader)new ExtendedTestClassLoader(configHolder));
            this.configHolder = configHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] runTestMethod(String className, String methodName, Map<String, String> protocolProps) {
            ArquillianConfig config = ArquillianService.this.getArquillianConfig(className, methodName, 30000L);
            Map<String, Object> properties = Collections.singletonMap(ArquillianService.TEST_CLASS_PROPERTY, className);
            ContextManager contextManager = this.setupContextManager(config, properties);
            try {
                byte[] byArray;
                DeploymentUnit depUnit;
                Module module;
                this.configHolder.set(config);
                ClassLoader runWithClassLoader = ClassLoader.getSystemClassLoader();
                if (Boolean.parseBoolean(protocolProps.get("enableThreadContextClassLoader")) && (module = (Module)(depUnit = config.getDeploymentUnit()).getAttachment(Attachments.MODULE)) != null) {
                    runWithClassLoader = module.getClassLoader();
                }
                ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)runWithClassLoader);
                try {
                    byArray = super.runTestMethod(className, methodName, protocolProps);
                }
                catch (Throwable throwable) {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
                    throw throwable;
                }
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
                return byArray;
            }
            finally {
                this.configHolder.remove();
                if (contextManager != null) {
                    contextManager.teardown(properties);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TestResult doRunTestMethod(TestRunner runner, Class<?> testClass, String methodName, Map<String, String> protocolProps) {
            ClassLoader runWithClassLoader = ClassLoader.getSystemClassLoader();
            if (Boolean.parseBoolean(protocolProps.get("enableThreadContextClassLoader"))) {
                DeploymentUnit depUnit;
                Module module;
                ArquillianConfig config = this.configHolder.get();
                if (config == null) {
                    config = ArquillianService.this.getArquillianConfig(testClass.getName(), methodName, 30000L);
                }
                if ((module = (Module)(depUnit = config.getDeploymentUnit()).getAttachment(Attachments.MODULE)) != null) {
                    runWithClassLoader = module.getClassLoader();
                }
            }
            ClassLoader tccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)runWithClassLoader);
            try {
                TestResult testResult = super.doRunTestMethod(runner, testClass, methodName, protocolProps);
                return testResult;
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)tccl);
            }
        }

        private ContextManager setupContextManager(ArquillianConfig config, Map<String, Object> properties) {
            try {
                DeploymentUnit depUnit = config.getDeploymentUnit();
                ContextManagerBuilder builder = new ContextManagerBuilder(config).addAll(depUnit);
                ContextManager contextManager = builder.build();
                contextManager.setup(properties);
                return contextManager;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private static class ArquillianListener
    implements LifecycleListener {
        private final ServiceTarget serviceTarget;

        private ArquillianListener(ServiceTarget serviceTarget) {
            this.serviceTarget = serviceTarget;
        }

        public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
            ServiceName serviceName = controller.getName();
            if (!Services.JBOSS_DEPLOYMENT.isParentOf(serviceName)) {
                return;
            }
            String simpleName = serviceName.getSimpleName();
            if (event == LifecycleEvent.DOWN && simpleName.equals(Phase.DEPENDENCIES.toString())) {
                ServiceName parentName = serviceName.getParent();
                ServiceController parentController = controller.getServiceContainer().getService(parentName);
                DeploymentUnit depUnit = (DeploymentUnit)parentController.getValue();
                ArquillianConfigBuilder.handleParseAnnotations(depUnit);
            } else if (event == LifecycleEvent.UP && simpleName.equals(Phase.INSTALL.toString())) {
                ServiceName parentName = serviceName.getParent();
                ServiceController parentController = controller.getServiceContainer().getService(parentName);
                DeploymentUnit depUnit = (DeploymentUnit)parentController.getValue();
                Map<String, ArquillianConfig.TestClassInfo> testClasses = ArquillianConfigBuilder.getClasses(depUnit);
                if (testClasses != null) {
                    String duName = ArquillianConfigBuilder.getName(depUnit);
                    ServiceName arqConfigSN = ServiceName.JBOSS.append(new String[]{"arquillian", "config", duName});
                    ServiceBuilder builder = this.serviceTarget.addService(arqConfigSN);
                    ArquillianConfig arqConfig = new ArquillianConfig(arqConfigSN, testClasses, builder.requires(SERVICE_NAME), builder.requires(parentController.getName()));
                    arqConfig.addDeps((ServiceBuilder<ArquillianConfig>)builder, controller);
                    builder.setInstance((Service)arqConfig);
                    builder.install();
                    log.infof("Arquillian deployment detected: %s", (Object)arqConfig);
                }
            }
        }
    }

    class ExtendedTestClassLoader
    implements JMXTestRunner.TestClassLoader {
        private final ThreadLocal<ArquillianConfig> configHolder;

        ExtendedTestClassLoader(ThreadLocal<ArquillianConfig> configHolder) {
            this.configHolder = configHolder;
        }

        public Class<?> loadTestClass(String className) throws ClassNotFoundException {
            ArquillianConfig arqConfig = this.configHolder.get();
            if (arqConfig == null && (arqConfig = ArquillianService.this.getArquillianConfig(className, -1L)) == null) {
                throw new ClassNotFoundException("No Arquillian config found for: " + className);
            }
            return arqConfig.loadClass(className);
        }
    }
}

