/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.modules;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Modules {
    private static final Set<Path> IMMUTABLE_MODULE_PATHS;

    public static Path discoverModulePath() {
        Path moduleDir;
        String modulePath = System.getProperty("module.path");
        if (modulePath == null) {
            String jbossHome = System.getProperty("jboss.home", System.getenv("JBOSS_HOME"));
            if (jbossHome == null) {
                throw new IllegalStateException("Neither -Dmodule.path nor -Djboss.home were set");
            }
            moduleDir = Path.of(jbossHome, "modules");
            if (Modules.isImmutableModulePath(moduleDir)) {
                throw new IllegalStateException(String.format("Writing test modules in jboss.home directory %s is not allowed.", jbossHome));
            }
        } else {
            String pathElement = null;
            for (String candidate : modulePath.split(File.pathSeparator)) {
                if (Modules.isImmutableModulePath(candidate)) continue;
                pathElement = candidate;
                break;
            }
            if (pathElement == null) {
                throw new IllegalStateException(String.format("Writing test modules in module.path directories %s is not allowed.", modulePath));
            }
            moduleDir = Path.of(pathElement, new String[0]);
        }
        if (Files.notExists(moduleDir, new LinkOption[0]) || !Files.isDirectory(moduleDir, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Module directory %s is not a directory.", moduleDir));
        }
        return moduleDir;
    }

    private static boolean isImmutableModulePath(Path path) {
        for (Path immutableModulePath : IMMUTABLE_MODULE_PATHS) {
            if (!Modules.contains(path, immutableModulePath)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImmutableModulePath(String path) {
        Path checking = Path.of(path, new String[0]);
        for (Path immutableModulePath : IMMUTABLE_MODULE_PATHS) {
            if (!Modules.contains(checking, immutableModulePath)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Path p1, Path p2) {
        int end;
        if (p1.equals(p2)) {
            return true;
        }
        if (p1.getNameCount() < p2.getNameCount()) {
            return false;
        }
        int start = -1;
        for (Path segment : p1) {
            ++start;
            if (!segment.equals(p2.getName(0))) continue;
            break;
        }
        if ((end = start + p2.getNameCount()) > p1.getNameCount()) {
            return false;
        }
        return p1.subpath(start, end).equals(p2);
    }

    static {
        String immutableModulePath = System.getProperty("org.wildfly.testing.tools.modules.immutable.paths");
        IMMUTABLE_MODULE_PATHS = immutableModulePath != null ? Stream.of(immutableModulePath.split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet()) : Set.of();
    }
}

