/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.deployments;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.wildfly.testing.tools.xml.CloseableXMLStreamWriter;

public class DeploymentDescriptors {
    private DeploymentDescriptors() {
    }

    public static <T extends WebContainer<T> & Archive<T>> T addJBossDeploymentStructure(T archive, Set<String> addedModules, Set<String> excludedModules) {
        return (T)((WebContainer)archive.addAsWebInfResource(DeploymentDescriptors.createJBossDeploymentStructureAsset(addedModules, excludedModules), "jboss-deployment-structure.xml"));
    }

    public static Asset createJBossDeploymentStructureAsset(Set<String> addedModules, Set<String> excludedModules) {
        return new ByteArrayAsset(DeploymentDescriptors.createJBossDeploymentStructure(addedModules, excludedModules));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] createJBossDeploymentStructure(Set<String> addedModules, Set<String> excludedModules) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            block17: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("jboss-deployment-structure");
                    writer.writeStartElement("deployment");
                    if (!addedModules.isEmpty()) {
                        writer.writeStartElement("dependencies");
                        for (String module : addedModules) {
                            writer.writeStartElement("module");
                            writer.writeAttribute("name", module);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (!excludedModules.isEmpty()) {
                        writer.writeStartElement("exclusions");
                        for (String module : addedModules) {
                            writer.writeStartElement("module");
                            writer.writeAttribute("name", module);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    object = out.toByteArray();
                    if (writer == null) break block17;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return object;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the jboss-deployment-structure.xml file.", e);
        }
    }

    public static Asset createJBossWebContextRoot(String contextRoot) {
        return DeploymentDescriptors.createJBossWebXmlAsset(Map.of("context-root", contextRoot));
    }

    public static Asset createJBossWebSecurityDomain(String securityDomain) {
        return DeploymentDescriptors.createJBossWebXmlAsset(Map.of("security-domain", securityDomain));
    }

    public static Asset createJBossWebXmlAsset(Map<String, String> elements) {
        return new ByteArrayAsset(DeploymentDescriptors.createJBossWebXml(elements));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] createJBossWebXml(Map<String, String> elements) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            block14: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("jboss-web");
                    for (Map.Entry<String, String> element : elements.entrySet()) {
                        writer.writeStartElement(element.getKey());
                        writer.writeCharacters(element.getValue());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    object = out.toByteArray();
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return object;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the jboss-deployment-structure.xml file.", e);
        }
    }

    public static Asset createPermissionsXmlAsset(Permission ... permissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions, additionalPermissions));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions, new Permission[0]));
    }

    public static byte[] createPermissionsXml(Permission ... permissions) {
        return DeploymentDescriptors.createPermissionsXml(List.of(permissions), new Permission[0]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] createPermissionsXml(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            block14: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("permissions");
                    writer.writeNamespace(null, "https://jakarta.ee/xml/ns/jakartaee");
                    writer.writeAttribute("version", "10");
                    DeploymentDescriptors.addPermissionXml(writer, permissions);
                    if (additionalPermissions != null && additionalPermissions.length > 0) {
                        DeploymentDescriptors.addPermissionXml(writer, List.of(additionalPermissions));
                    }
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    byArray = out.toByteArray();
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byArray;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the permissions.xml file.", e);
        }
    }

    public static Collection<Permission> addModuleFilePermission(String ... moduleNames) {
        String value = System.getProperty("module.jar.path");
        if (value == null || value.isBlank()) {
            return Collections.emptySet();
        }
        Path moduleDir = Path.of(value, new String[0]);
        ArrayList<Permission> result = new ArrayList<Permission>();
        for (String moduleName : moduleNames) {
            Path definedModuleDir = moduleDir.resolve(moduleName.replace('.', File.separatorChar)).resolve("main");
            try (Stream<Path> stream = Files.walk(definedModuleDir, new FileVisitOption[0]);){
                stream.filter(path -> path.getFileName().toString().endsWith(".jar")).map(path -> new FilePermission(path.toAbsolutePath().toString(), "read")).forEach(result::add);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return result;
    }

    public static Collection<FilePermission> createTempDirPermission(String actions) {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (((String)tempDir).charAt(((String)tempDir).length() - 1) != File.separatorChar) {
            tempDir = (String)tempDir + File.separatorChar;
        }
        return List.of(new FilePermission((String)tempDir, "read"), new FilePermission((String)tempDir + "-", actions));
    }

    private static void addPermissionXml(XMLStreamWriter writer, Iterable<? extends Permission> permissions) throws XMLStreamException {
        for (Permission permission : permissions) {
            writer.writeStartElement("permission");
            writer.writeStartElement("class-name");
            writer.writeCharacters(permission.getClass().getName());
            writer.writeEndElement();
            writer.writeStartElement("name");
            writer.writeCharacters(permission.getName());
            writer.writeEndElement();
            String actions = permission.getActions();
            if (actions != null && !actions.isEmpty()) {
                writer.writeStartElement("actions");
                writer.writeCharacters(actions);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

