/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.modules;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.testing.tools.modules.ModuleDependency;
import org.wildfly.testing.tools.modules.ModuleDescription;
import org.wildfly.testing.tools.modules.Modules;
import org.wildfly.testing.tools.xml.CloseableXMLStreamWriter;

public class ModuleBuilder {
    private final String name;
    private final Path modulePath;
    private final JavaArchive jar;
    private final Set<String> resourcePaths;
    private final Set<JavaArchive> resources;
    private final Set<ModuleDependency> dependencies;

    private ModuleBuilder(String name, JavaArchive jar, Path modulePath) {
        this.name = name;
        this.modulePath = modulePath == null ? Modules.discoverModulePath() : modulePath;
        this.jar = jar;
        this.dependencies = new LinkedHashSet<ModuleDependency>();
        this.resources = new LinkedHashSet<JavaArchive>();
        this.resourcePaths = new LinkedHashSet<String>();
    }

    private ModuleBuilder(String name, String archiveName, Path modulePath) {
        this(name, (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(archiveName == null ? "test-module.jar" : archiveName)), modulePath);
    }

    public static ModuleBuilder of(String moduleName) {
        return ModuleBuilder.of(moduleName, (String)null);
    }

    public static ModuleBuilder of(String moduleName, JavaArchive jar) {
        return ModuleBuilder.of(moduleName, jar, null);
    }

    public static ModuleBuilder of(String moduleName, String archiveName) {
        return new ModuleBuilder(moduleName, archiveName, null);
    }

    public static ModuleBuilder of(String moduleName, String archiveName, Path modulePath) {
        return new ModuleBuilder(moduleName, archiveName, modulePath);
    }

    public static ModuleBuilder of(String moduleName, JavaArchive jar, Path modulePath) {
        return new ModuleBuilder(moduleName, jar, modulePath);
    }

    public String name() {
        return this.name;
    }

    public ModuleBuilder addAsset(Asset asset, String target) {
        this.jar.add(asset, target);
        return this;
    }

    public ModuleBuilder addClass(Class<?> c) {
        this.jar.addClass(c);
        return this;
    }

    public ModuleBuilder addClasses(Class<?> ... classes) {
        this.jar.addClasses((Class[])classes);
        return this;
    }

    public ModuleBuilder addDependency(String dependency) {
        this.dependencies.add(ModuleDependency.builder(dependency).build());
        return this;
    }

    public ModuleBuilder addDependencies(String ... dependencies) {
        for (String dependency : dependencies) {
            this.addDependency(dependency);
        }
        return this;
    }

    public ModuleBuilder addDependency(ModuleDependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public ModuleBuilder addDependencies(ModuleDependency ... dependencies) {
        return this.addDependencies(Set.of(dependencies));
    }

    public ModuleBuilder addDependencies(Collection<ModuleDependency> dependencies) {
        this.dependencies.addAll(dependencies);
        return this;
    }

    public ModuleBuilder addServiceProvider(Class<?> intf, Class<?> ... implementations) {
        ModuleBuilder.validate(intf, implementations);
        this.jar.addAsServiceProvider(intf, (Class[])implementations);
        return this;
    }

    public ModuleBuilder addPackage(String p) {
        this.jar.addPackage(p);
        return this;
    }

    public ModuleBuilder addPackage(Package p) {
        this.jar.addPackage(p);
        return this;
    }

    public ModuleBuilder addManifestResource(Asset asset, String target) {
        this.jar.addAsManifestResource(asset, target);
        return this;
    }

    public ModuleBuilder addResource(JavaArchive resource) {
        this.resources.add(resource);
        return this;
    }

    public ModuleBuilder addResources(JavaArchive ... resources) {
        this.resources.addAll(Set.of(resources));
        return this;
    }

    public ModuleBuilder addResources(Collection<JavaArchive> resources) {
        this.resources.addAll(resources);
        return this;
    }

    public ModuleBuilder addResourcePath(String resourcePath) {
        this.resourcePaths.add(resourcePath);
        return this;
    }

    public ModuleBuilder addResourcePaths(String ... resourcePaths) {
        this.resourcePaths.addAll(Set.of(resourcePaths));
        return this;
    }

    public ModuleBuilder addResourcePaths(Set<String> resourcePaths) {
        this.resourcePaths.addAll(resourcePaths);
        return this;
    }

    public ModuleDescription build() {
        try {
            Path mp = this.modulePath;
            Path moduleDir = mp.resolve(this.name.replace('.', File.separatorChar)).resolve("main");
            if (Files.notExists(moduleDir, new LinkOption[0])) {
                Files.createDirectories(moduleDir, new FileAttribute[0]);
            }
            Path fullPathToDelete = moduleDir.subpath(0, mp.getNameCount() + 1);
            this.createModule(moduleDir);
            return new ModuleDescription(this.name, mp, moduleDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createModule(Path moduleDir) throws IOException {
        Files.createDirectories(moduleDir, new FileAttribute[0]);
        try (CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(Files.newBufferedWriter(moduleDir.resolve("module.xml"), new OpenOption[0]));){
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeStartElement("module");
            writer.writeNamespace(null, "urn:jboss:module:1.9");
            writer.writeAttribute("name", this.name);
            writer.writeStartElement("resources");
            writer.writeEmptyElement("resource-root");
            writer.writeAttribute("path", this.jar.getName());
            for (String string : this.resourcePaths) {
                writer.writeEmptyElement("resource-root");
                writer.writeAttribute("path", string);
            }
            for (JavaArchive javaArchive : this.resources) {
                writer.writeEmptyElement("resource-root");
                writer.writeAttribute("path", javaArchive.getName());
                OutputStream out = Files.newOutputStream(moduleDir.resolve(javaArchive.getName()), StandardOpenOption.CREATE_NEW);
                try {
                    ((ZipExporter)javaArchive.as(ZipExporter.class)).exportTo(out);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            writer.writeEndElement();
            if (!this.dependencies.isEmpty()) {
                writer.writeStartElement("dependencies");
                for (ModuleDependency moduleDependency : this.dependencies) {
                    boolean emptyElement;
                    boolean bl = emptyElement = moduleDependency.imports().isEmpty() && moduleDependency.exports().isEmpty();
                    if (emptyElement) {
                        writer.writeEmptyElement("module");
                    } else {
                        writer.writeStartElement("module");
                    }
                    writer.writeAttribute("name", moduleDependency.name());
                    if (moduleDependency.isExport()) {
                        writer.writeAttribute("export", "true");
                    }
                    if (moduleDependency.isOptional()) {
                        writer.writeAttribute("optional", "true");
                    }
                    if (moduleDependency.services().isPresent()) {
                        writer.writeAttribute("services", moduleDependency.services().get().toString());
                    }
                    if (emptyElement) continue;
                    if (!moduleDependency.imports().isEmpty()) {
                        writer.writeStartElement("imports");
                        for (ModuleDependency.Filter filter : moduleDependency.imports()) {
                            if (filter.include()) {
                                writer.writeEmptyElement("include");
                                writer.writeAttribute("path", filter.path());
                                continue;
                            }
                            writer.writeEmptyElement("exclude");
                            writer.writeAttribute("path", filter.path());
                        }
                        writer.writeEndElement();
                    }
                    if (!moduleDependency.exports().isEmpty()) {
                        writer.writeStartElement("exports");
                        for (ModuleDependency.Filter filter : moduleDependency.exports()) {
                            if (filter.include()) {
                                writer.writeEmptyElement("include");
                                writer.writeAttribute("path", filter.path());
                                continue;
                            }
                            writer.writeEmptyElement("exclude");
                            writer.writeAttribute("path", filter.path());
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        try (OutputStream out = Files.newOutputStream(moduleDir.resolve(this.jar.getName()), StandardOpenOption.CREATE_NEW);){
            ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo(out);
        }
    }

    private static void validate(Class<?> type, Class<?> ... subtypes) {
        LinkedHashSet invalidTypes = new LinkedHashSet();
        for (Class<?> subtype : subtypes) {
            if (type.isAssignableFrom(subtype)) continue;
            invalidTypes.add(subtype);
        }
        if (!invalidTypes.isEmpty()) {
            StringBuilder msg = new StringBuilder("The following types are not subtypes of ").append(type.getCanonicalName()).append(" : ");
            Iterator iter = invalidTypes.iterator();
            while (iter.hasNext()) {
                msg.append(((Class)iter.next()).getCanonicalName());
                if (!iter.hasNext()) continue;
                msg.append(", ");
            }
            throw new IllegalArgumentException(msg.toString());
        }
    }
}

