/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.StandaloneAetherArtifactFileResolver;
import org.wildfly.build.pack.model.DelegatingArtifactResolver;
import org.wildfly.build.pack.model.FeaturePackArtifactResolver;
import org.wildfly.build.provisioning.ServerProvisioner;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.provisioning.model.ServerProvisioningDescriptionModelParser;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertiesBasedArtifactResolver;

public class ProvisionCommand {
    public static void provision(String[] args) {
        File configFile = new File(args.length == 1 ? args[0] : "server-provisioning.xml");
        ProvisionCommand.provision(configFile);
    }

    public static void provision(File configFile) {
        Properties environment = System.getProperties();
        File buildDir = new File("target");
        buildDir.mkdirs();
        File mavenLocalRepositoryBaseDir = new File(new File(System.getProperty("user.home"), ".m2"), "repository");
        StandaloneAetherArtifactFileResolver aetherArtifactFileResolver = new StandaloneAetherArtifactFileResolver(mavenLocalRepositoryBaseDir.exists() ? mavenLocalRepositoryBaseDir : new File(buildDir, "repository"));
        try (FileInputStream configStream = new FileInputStream(configFile);){
            ServerProvisioningDescription serverProvisioningDescription = new ServerProvisioningDescriptionModelParser(new MapPropertyResolver(environment)).parse(configStream);
            ArtifactResolver overrideArtifactResolver = new FeaturePackArtifactResolver(serverProvisioningDescription.getVersionOverrides());
            if (Boolean.valueOf(environment.getProperty("system-property-version-overrides", "false")).booleanValue()) {
                overrideArtifactResolver = new DelegatingArtifactResolver(new PropertiesBasedArtifactResolver(environment), overrideArtifactResolver);
            }
            File outputDir = new File(buildDir, "wildfly");
            ServerProvisioner.build(serverProvisioningDescription, outputDir, false, aetherArtifactFileResolver, overrideArtifactResolver);
            System.out.print("Server provisioning at " + outputDir + " complete.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

